package com.xdja.framework.validation.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;

import com.xdja.framework.validation.ValidatorUtils;
import com.xdja.framework.validation.annotation.SpringValid;
import com.xdja.framework.validation.utils.ReflectionUtils;
import com.xdja.framework.validation.validator.ValidationResult;

/**
 * Spring验证拦截器，对指定的方法进行拦截，对参数(有 {@link SpringValid}注解)进行验证。
 * 若验证不通过，会抛出{@link SpringValidationException}。
 * 
 * @author lvhao
 *
 * 增加验证失败异常信息提示
 * @author hsun
 * @date 2018-09-06 18:31:48
 *
 */
public class SpringValidationInterceptor implements MethodInterceptor {
	
	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Class<?> targetClass = (invocation.getThis() != null ? AopUtils.getTargetClass(invocation.getThis()) : null);
		if (targetClass == null) {
			throw new NullPointerException("Target class cannot be null");
		}
		Object[] arguments = invocation.getArguments();
		if (arguments == null || arguments.length == 0) {
			return invocation.proceed();
		}
		Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
		 Method implMethod = ReflectionUtils.getMethod(targetClass, invocation.getMethod().getName(), parameterTypes);
		 if (implMethod != null) {
			 Annotation[][] paramAnnotations = implMethod.getParameterAnnotations();
			 if (paramAnnotations != null && paramAnnotations.length >0) {
				 for (int i = 0; i < paramAnnotations.length; i++) {
					 Annotation[] paramAnnotation = paramAnnotations[i];
					 if (paramAnnotation == null) {
						 continue;
					 }
					 
					 for (int j = 0; j < paramAnnotation.length; j++) {
						 if (paramAnnotation[j].annotationType() == SpringValid.class) {
							 SpringValid springValid = (SpringValid) paramAnnotation[j];
							 ValidationResult result = ValidatorUtils.validate(arguments[i], springValid.failFast(), springValid.groups());
							 if (!result.isSuccess()) {
								 throw new SpringValidationException("params validated failed", result);
							}
						 }
					 }
					 
				 }
			 }
		}
         return invocation.proceed();
	}

}
