package com.xdja.framework.validation.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import com.xdja.framework.validation.validator.Validator;

public class AnnotationMetadata {

	/**
	 * 针对于Binding注解的名称，便于InjectBinding快速查找
	 */
	private String bindingName;
	/**
	 * Binding的字段，也就是具有相同bindingName的InjectBinding的字段
	 */
	private List<FieldMetadata> bindingFields = new ArrayList<FieldMetadata>(4);
	/**
	 * 注解对象
	 */
	private Annotation annotation;

	/**
	 * 校验器类名
	 */
	@SuppressWarnings("rawtypes")
	private Class<? extends Validator> validatorClass;

	public Annotation getAnnotation() {
		return annotation;
	}

	public void setAnnotation(Annotation annotation) {
		this.annotation = annotation;
	}

	@SuppressWarnings("rawtypes")
	public Class<? extends Validator> getValidatorClass() {
		return validatorClass;
	}

	@SuppressWarnings("rawtypes")
	public void setValidatorClass(Class<? extends Validator> validatorClass) {
		this.validatorClass = validatorClass;
	}
	
	public String getBindingName() {
		return bindingName;
	}

	public void setBindingName(String bindingName) {
		this.bindingName = bindingName;
	}
	
	public List<FieldMetadata> getBindingFields() {
		return bindingFields;
	}

	public void setBindingFields(List<FieldMetadata> bindingFields) {
		this.bindingFields = bindingFields;
	}

	@Override
	public String toString() {
		return "AnnotationMetadata [annotation=" + annotation + ", validatorClass=" + validatorClass + "]";
	}

}
