package com.xdja.framework.validation.metadata;

import java.lang.reflect.Field;
import java.util.List;

public class FieldMetadata {

	/**
	 * 属性顺序，用于定义各个属性校验的前后顺序
	 */
	private int order = 1;
	/**
	 * 属性名称
	 */
	private transient Field field;
	/**
	 * 属性具有的校验注解
	 */
	private List<AnnotationMetadata> annotations;
	/**
	 * 引用属性注解，属性为对象类型，则引用该对象的属性注解
	 */
	private ClassMetadata reference;

	public int getOrder() {
		return order;
	}

	public void setOrder(int order) {
		this.order = order;
	}

	public Field getField() {
		return field;
	}

	public void setField(Field field) {
		this.field = field;
	}

	public List<AnnotationMetadata> getAnnotations() {
		return annotations;
	}

	public void setAnnotations(List<AnnotationMetadata> annotations) {
		this.annotations = annotations;
	}

	public ClassMetadata getReference() {
		return reference;
	}

	public void setReference(ClassMetadata reference) {
		this.reference = reference;
	}

	@Override
	public String toString() {
		return "FieldMetadata [order=" + order + ", field=" + field + ", annotations=" + annotations + ", reference=" + reference + "]";
	}

}
