package com.xdja.framework.validation.metadata;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

import com.xdja.framework.validation.validator.Validator;

/**
 * 分组元数据
 * 
 */
public class GroupMetadata {

	/**
	 * 分组名称
	 */
	private String name;
	/**
	 * 分组内指定的成员属性
	 */
	private List<String> fields;
	/**
	 * 分组内的成员属性名与注解的关系Map
	 */
	private Map<String, Class<? extends Annotation>[]> fieldAnnotationsMap;
	/**
	 * 分组内的成员属性名与校验器的关系Map
	 */
	@SuppressWarnings("rawtypes")
	private Map<String, Class<? extends Validator>[]> fieldValidatorsMap;
	/**
	 * 分组内的成员属性名与成员对象分组的关系Map
	 */
	private Map<String, String[]> fieldGroupsMap;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List<String> getFields() {
		return fields;
	}

	public void setFields(List<String> fields) {
		this.fields = fields;
	}

	public Map<String, Class<? extends Annotation>[]> getFieldAnnotationsMap() {
		return fieldAnnotationsMap;
	}

	public void setFieldAnnotationsMap(Map<String, Class<? extends Annotation>[]> fieldAnnotationsMap) {
		this.fieldAnnotationsMap = fieldAnnotationsMap;
	}

	@SuppressWarnings("rawtypes")
	public Map<String, Class<? extends Validator>[]> getFieldValidatorsMap() {
		return fieldValidatorsMap;
	}

	@SuppressWarnings("rawtypes")
	public void setFieldValidatorsMap(Map<String, Class<? extends Validator>[]> fieldValidatorsMap) {
		this.fieldValidatorsMap = fieldValidatorsMap;
	}

	public Map<String, String[]> getFieldGroupsMap() {
		return fieldGroupsMap;
	}

	public void setFieldGroupsMap(Map<String, String[]> fieldGroupsMap) {
		this.fieldGroupsMap = fieldGroupsMap;
	}

}
