package com.xdja.framework.validation.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xdja.framework.validation.annotation.ValidatorBy;
import com.xdja.framework.validation.metadata.AnnotationMetadata;
import com.xdja.framework.validation.metadata.ClassMetadata;
import com.xdja.framework.validation.metadata.FieldMetadata;
import com.xdja.framework.validation.metadata.GroupMetadata;
import com.xdja.framework.validation.validator.ValidationException;
import com.xdja.framework.validation.validator.Validator;

public class ClassMetadataHelper {

	/**
	 * 从类元数据中根据分组加载指定字段的元数据。
	 * @param from
	 * @param groups
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static ClassMetadata loadByGroups(ClassMetadata from, String[] groups) {
		if (groups == null || groups.length == 0) {
			return from;
		}
		
		//新的结果数据
		List<FieldMetadata> newFieldMetadatas = new ArrayList<FieldMetadata>();
		Map<String, Class<? extends Validator>> newGroupClassValidatorMap = new HashMap<String, Class<? extends Validator>>();
		
		//原数据
		Map<String, GroupMetadata> groupMetadataMap = from.getGroupMetadataMap();
		Map<String, Class<? extends Validator>> groupClassValidatorMap = from.getGroupClassValidatorMap();
		
		//全部分组名称
		List<String> groupNames = new ArrayList<String>();
		if (groupClassValidatorMap != null && !groupClassValidatorMap.isEmpty()) {
			groupNames.addAll(groupClassValidatorMap.keySet());
		}
		if (groupMetadataMap != null && !groupMetadataMap.isEmpty()) {
			groupNames.addAll(groupMetadataMap.keySet());
		}
		
		//检查group是否存在
		for (String group : groups) {
			if (!groupNames.contains(group)) {
				throw new ValidationException("分组[" + group + "]不存在");
			}
		}
		
		if (groupClassValidatorMap != null && !groupClassValidatorMap.isEmpty()) {
			for (String group : groups) {
				Class<? extends Validator> validatorClass = groupClassValidatorMap.get(group);
				if (validatorClass == null) {
					continue;
				}
				newGroupClassValidatorMap.put(group, validatorClass);
			}
		}
		
		if (groupMetadataMap != null && !groupMetadataMap.isEmpty()) {
			for (String group : groups) {
				GroupMetadata groupMetadata = groupMetadataMap.get(group);
				if (groupMetadata == null) {
					continue;
				}
				List<String> fields = groupMetadata.getFields();
				List<FieldMetadata> fieldMetadatas = from.getFieldMetadatas();
				
				//检查字段是否存在
				for (String field : fields) {
					boolean find = false;
					for (FieldMetadata fieldMetadata : fieldMetadatas) {
						if (field.equals(fieldMetadata.getField().getName())) {
							find = true;
							break;
						}
					}
					
					if (!find) {
						throw new ValidationException("字段[" + field + "]不存在");
					}
				}
				
				
				for (FieldMetadata fieldMetadata : fieldMetadatas) {
					String fieldName = fieldMetadata.getField().getName();
					if (fields.contains(fieldName)) {
						FieldMetadata newFieldMetadata = new FieldMetadata();
						newFieldMetadata.setOrder(fieldMetadata.getOrder());
						newFieldMetadata.setField(fieldMetadata.getField());
						
						//1
						Class<? extends Annotation>[] annotationClasses = groupMetadata.getFieldAnnotationsMap().get(fieldName);
						//如果分组中指定验证注解，则找到这些注解，加入到新的元数据中，注意是对象引用。
						List<AnnotationMetadata> newAnnotations = new ArrayList<AnnotationMetadata>(annotationClasses.length);
						for (Class<? extends Annotation> annotationClass : annotationClasses) {
							boolean found = false;
							for (AnnotationMetadata annotationMetadata : fieldMetadata.getAnnotations()) {
								if (annotationMetadata.getAnnotation().annotationType() == annotationClass) {
									found = true;
									newAnnotations.add(annotationMetadata);
									break;
								}
							}
							if (!found) {
								throw new ValidationException("字段[" + fieldName + "]不存在的验证注解" + annotationClass);
							}
						}
						
						
						//2
						Class<? extends Validator>[] validatorClasses = groupMetadata.getFieldValidatorsMap().get(fieldName);
						//将新定义的验证器放入到注解元数据中
						for (Class<? extends Validator> validatorClass : validatorClasses) {
							AnnotationMetadata annotationMetadata = new AnnotationMetadata();
							//构造ValidatorBy注解
							annotationMetadata.setAnnotation(getInstance(validatorClass));
							annotationMetadata.setValidatorClass(validatorClass);
							newAnnotations.add(annotationMetadata);
						}
						newFieldMetadata.setAnnotations(newAnnotations);
						
						
						//3
						//过滤对象字段的分组
						String[] fieldGroups = groupMetadata.getFieldGroupsMap().get(fieldName);
						if (fieldGroups.length !=0 && fieldMetadata.getReference() == null) {
							throw new ValidationException("字段[" + fieldName + "]不存在分组");
						}
						if (fieldGroups.length !=0) {
							//递归加载
							ClassMetadata reference = loadByGroups(fieldMetadata.getReference(), fieldGroups);
							newFieldMetadata.setReference(reference);
						}
						
						//如果分组未指定字段的校验器，则认为是字段的全部校验器
						if (newFieldMetadata.getAnnotations().isEmpty() && newFieldMetadata.getReference() == null) {
							newFieldMetadata = fieldMetadata;
						}
						
						newFieldMetadatas.add(newFieldMetadata);
						
					}
				}
			}
		}
		
		ClassMetadata to = new ClassMetadata();
		to.setCls(from.getCls());
		to.setFieldMetadatas(newFieldMetadatas);
		to.setGroupMetadataMap(groupMetadataMap);
		to.setGroupClassValidatorMap(groupClassValidatorMap);
		return to;
	}
	
	@SuppressWarnings("rawtypes")
	private static ValidatorBy getInstance(final Class<? extends Validator> cls) {
		ValidatorBy annotation = new ValidatorBy() {
			@Override
			public Class<? extends Annotation> annotationType() {
				return ValidatorBy.class;
			}

			@Override
			public String name() {
				return "";
			}

			@Override
			public Class<? extends Validator> value() {
				return cls;
			}

			@Override
			public int order() {
				return 1;
			}
		};
		return annotation;
	}
}
