package com.xdja.framework.validation.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

import com.xdja.framework.validation.validator.ValidationException;

public class ObjectUtils {

	/**
	 * 获取指定对象的元素。当指定对象为Collection或Array时，获取第一个元素；其他情况返回对象本身。 当元素为null，抛出NullPointerException
	 * 
	 * @param obj
	 * @return
	 */
	public static Object getElement(Object obj) throws NullPointerException {
		Class<?> cls = obj.getClass();
		if (Collection.class.isAssignableFrom(cls)) {
			// 是集合，则取出集合中的第一个元素，提取校验器
			@SuppressWarnings("rawtypes")
			Collection collection = (Collection) obj;
			if (!collection.isEmpty()) {
				Object element = collection.iterator().next();
				if (element == null) {
					throw new ValidationException("集合元素为null");
				}
				return element;
			}
		} else if (cls.isArray()) {// 数组
			Object[] objects = (Object[]) obj;
			if (objects.length > 0) {
				Object element = objects[0];
				if (element == null) {
					throw new ValidationException("数组元素为null");
				}
				return element;
			}
		}
		return obj;
	}

	/**
	 * 获取指定对象的元素类型。当指定对象为Collection或Array时，获取第一个元素类型；其他情况返回对象类型。
	 * 
	 * @param obj
	 * @return
	 */
	public static Class<?> getElementClass(Object obj) throws NullPointerException {
		return getElement(obj).getClass();
	}

	/**
	 * 判断对象上是否为集合
	 * 
	 * @param obj
	 * @return
	 */
	public static boolean isCollection(Object obj) {
		Class<?> cls = obj.getClass();
		if (Collection.class.isAssignableFrom(cls)) {
			return true;
		}
		return false;
	}

	/**
	 * 判断对象是否为数组
	 * 
	 * @param obj
	 * @return
	 */
	public static boolean isArray(Object obj) {
		Class<?> cls = obj.getClass();
		if (cls.isArray()) {
			return true;
		}
		return false;
	}

	/**
	 * 将指定对象转成为Iterator。若obj是Collection，构造迭代器返回。若obj是数组，转成ArrayList的迭代器返回。其他情况返回null。
	 * 
	 * @param obj
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static Iterator toIter(Object obj) {
		Class<?> cls = obj.getClass();
		if (Collection.class.isAssignableFrom(cls)) {
			Collection collection = (Collection) obj;
			if (!collection.isEmpty()) {
				return collection.iterator();
			}
		} else if (cls.isArray()) {// 数组
			Object[] objects = (Object[]) obj;
			if (objects.length > 0) {
				return Arrays.asList(objects).iterator();
			}
		}
		return null;
	}
	
	/**
	 * 判断指定对象是否为空的集合或空数组。obj为null，返回false。
	 * @param obj
	 * @return
	 */
	public static boolean isEmptyCollectionOrArray(Object obj) {
		if (obj == null) {
			//null值不做处理，仅对于集合或数组处理
			return false;
		}
		Class<?> cls = obj.getClass();
		if (Collection.class.isAssignableFrom(cls)) {
			@SuppressWarnings("rawtypes")
			Collection collection = (Collection) obj;
			if (collection.isEmpty()) {
				return true;
			}
		} else if (cls.isArray()) {// 数组
			Object[] objects = (Object[]) obj;
			if (objects.length == 0) {
				return true;
			}
		}
		return false;
	}
}
