package com.xdja.framework.validation.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtils {
	
	/**
	 * 判断是否有超类
	 *
	 * @param clazz
	 *            目标类
	 *
	 * @return 如果有返回<code>true</code>，否则返回<code>false</code>
	 */
	public static boolean hasSuperClass(Class<?> clazz) {
		return (clazz != null) && !clazz.equals(Object.class);
	}

	/**
	 * 获取指定类的获取成员属性，包括父类的成员属性，但是不包括Object的成员属性
	 * @param clazz
	 * @return
	 */
	public static List<Field> getAllFieldsOfClass(Class<?> clazz) {
		List<Field> fields = new ArrayList<Field>();
		for (Class<?> itr = clazz; hasSuperClass(itr);) {
			fields.addAll(Arrays.asList(itr.getDeclaredFields()));
			itr = itr.getSuperclass();
		}
		return fields;
	}
	
	
	/**
     * 获取方法
     *
     * @param clazz          类
     * @param methodName     方法名
     * @param parameterTypes 方法参数
     *
     * @return 方法
     */
    public static Method getMethod(Class<?> clazz, String methodName, Class<?>... parameterTypes) {
        if (clazz == null || methodName == null || methodName.length() == 0) {
            return null;
        }

        for (Class<?> itr = clazz; hasSuperClass(itr); ) {
            Method[] methods = itr.getDeclaredMethods();

            for (Method method : methods) {
                if (method.getName().equals(methodName) && Arrays.equals(method.getParameterTypes(), parameterTypes)) {
                    return method;
                }
            }

            itr = itr.getSuperclass();
        }
        return null;
    }

	
}
