package com.xdja.framework.validation.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SortList {

	@SuppressWarnings("rawtypes")
	private List list = null;
	/**
	 * The size of list
	 */
	private int size = 0;
	/**
	 * The limit of list, auto increasing based on the order parameter.
	 */
	private int limit = 0;

	public SortList(int size) {
		list = makeFixedSizeList(list, size);
		limit = size;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private List makeFixedSizeList(List list, int size) {
		if (list == null) {
			list = new ArrayList(size);
		}
		int index = list.size() - 1;
		while (index < size - 1) {
			list.add(null);
			index++;
		}

		return list;
	}

	public boolean isEmpty() {
		return size == 0;
	}

	@SuppressWarnings("unchecked")
	public void insert(Object element, int order) {
		if (order < 1) {
			throw new IllegalArgumentException("order cannot be less than 1");
		}
		if (order > limit) {
			list = makeFixedSizeList(list, order);
			limit = order;
		}

		if (list.get(order - 1) == null) {
			size++;
			list.set(order - 1, element);
		} else {
			int i = order;
			while (true) {
				if (list.get(i) == null) {
					size++;
					list.set(i, element);
					break;
				}
				i++;
			}
		}
	}

	@SuppressWarnings("rawtypes")
	public List getList() {
		return removeNull();
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private List removeNull() {
		if (!isEmpty()) {
			List result = new ArrayList(size);
			Iterator iterator = list.iterator();
			while (iterator.hasNext()) {
				Object object = iterator.next();
				if (object != null) {
					result.add(object);
				}
			}
			return result;
		}
		return null;
	}
	
}
