package com.xdja.framework.validation.validator;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ValidationContext {
	
	/**
	 * 待校验的成员属性，类级别校验是field为null。
	 */
	private Field field;

	  /**
     * 调用结果对象
     */
    private ValidationResult result;
    
    /**
     * 绑定到该字段的其他字段值
     */
    private Map<String, Object> bindingValues = new HashMap<String, Object>(4);
    
    /**
     * 原类
     */
    private Class<?> cls;
    
    public Field getField() {
		return field;
	}

	public void setField(Field field) {
		this.field = field;
	}

	public ValidationResult getResult() {
		return result;
	}

	public void setResult(ValidationResult result) {
		this.result = result;
	}
	
	public Map<String, Object> getBindingValues() {
		return bindingValues;
	}

	public void setBindingValues(Map<String, Object> bindingValues) {
		this.bindingValues = bindingValues;
	}
	
	public Class<?> getCls() {
		return cls;
	}

	public void setCls(Class<?> cls) {
		this.cls = cls;
	}

	/**
     * 添加错误信息
     *
     * @param msg 错误信息
     */
    public void addErrorMsg(String msg) {
    	ValidationError error = ValidationError.create(msg);
    	//类级别校验field为null
    	if (field != null) {
    		error.setField(field.getName());
		}
        result.addError(error);
    }

    /**
     * 添加错误信息
     *
     * @param validationError 验证错误
     */
    public void addError(ValidationError validationError) {
        result.addError(validationError);
    }

}
