package com.xdja.framework.validation.validator;

public class ValidationError {

    /**
     * 错误消息
     */
    private String errorMsg;

    /**
     * 错误字段名
     */
    private String field;

    /**
     * 错误值
     */
    private Object invalidValue;

    /**
     * 静态构造方法
     *
     * @param errorMsg 错误信息，其他信息可以省略，但是一个错误认为错误消息决不可少
     *
     * @return ValidationError
     */
    public static ValidationError create(String errorMsg) {
        return new ValidationError().setErrorMsg(errorMsg);
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public ValidationError setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public String getField() {
        return field;
    }

    public ValidationError setField(String field) {
        this.field = field;
        return this;
    }

    public Object getInvalidValue() {
        return invalidValue;
    }

    public ValidationError setInvalidValue(Object invalidValue) {
        this.invalidValue = invalidValue;
        return this;
    }

	@Override
	public String toString() {
		return "ValidationError [field=" + field + ", invalidValue=" + invalidValue + ", errorMsg=" + errorMsg + "]";
	}

}
