package com.xdja.framework.validation.validator;

/**
 * 验证器接口。
 * <p/>
 * 泛型<t>T</t>表示待验证对象的类型
 *
 */
public interface Validator<T> {
	
	/**
	 * 判断校验器是否对指定对象的进行校验。返回true，才会执行validate方法
	 * @param context
	 * @param object
	 * @return
	 */
	boolean accept(ValidationContext context, Object object);

    /**
     * 执行验证
     * <p/>
     * 如果发生错误内部需要调用{@link ValidatorContext#addErrorMsg(String)}方法，也即<code>context.addErrorMsg(String)
     * </code>来添加错误，该错误会被添加到结果存根{@link Result}的错误消息列表中。
     *
     * @param context 验证上下文
     * @param t       待验证对象
     *
     * @return 是否验证通过
     */
    boolean validate(ValidationContext context, T t);

}
