package com.xdja.framework.validation.validator.internal;

import java.lang.reflect.Field;

import com.xdja.framework.validation.annotation.EmptyCheck;
import com.xdja.framework.validation.annotation.EmptyCheck.CheckType;
import com.xdja.framework.validation.validator.ValidationContext;
import com.xdja.framework.validation.validator.ValidationError;
import com.xdja.framework.validation.validator.Validator;

public class EmptyCheckValidator implements Validator<Object> {
	
	@Override
	public boolean accept(ValidationContext context, Object t) {
		Field f = context.getField();
		EmptyCheck emptyCheck = f.getAnnotation(EmptyCheck.class);
		if(emptyCheck == null){
			return false;
		}
		return true;
	}

	@Override
	public boolean validate(ValidationContext context, Object t) {
		Field f = context.getField();
		EmptyCheck emptyCheck = f.getAnnotation(EmptyCheck.class);
		
		Object value = t;
		String message = emptyCheck.message();

		boolean failed = false;
		
		if (emptyCheck.checkType() == CheckType.NULL) {
			if (value != null) {
				failed = true;
			}
		}else if (emptyCheck.checkType() == CheckType.NOT_NULL) {
			if (value == null) {
				failed = true;
			}

		} else if (emptyCheck.checkType() == CheckType.NOT_EMPTY) {
			if (value == null) {
				failed = true;
			} else if (value instanceof String) {
				if (((String) value).length() == 0) {
					failed = true;
				}
			}
		} else if (emptyCheck.checkType() == CheckType.NOT_BLANK) {
			if (value == null) {
				failed = true;
			} else if (value instanceof String) {
				if (((String) value).trim().length() == 0) {
					failed = true;
				}
			}
		}
		
		if (failed) {
			ValidationError validationError = new ValidationError();
			validationError.setField(f.getName());
			validationError.setErrorMsg(message);
			validationError.setInvalidValue(value);
			context.addError(validationError);
			return false;
		}
		return true;
	}
	
	
}
