package com.xdja.framework.validation.validator.internal;

import java.lang.reflect.Field;

import com.xdja.framework.validation.annotation.Length;
import com.xdja.framework.validation.validator.ValidationContext;
import com.xdja.framework.validation.validator.ValidationError;
import com.xdja.framework.validation.validator.Validator;

public class LengthValidator implements Validator<Object>{

	@Override
	public boolean accept(ValidationContext context, Object t) {
		if (t == null) {
			return false;
		}
		Field field = context.getField();
		Length length = field.getAnnotation(Length.class);
		if (length != null) {
			return true;
		}
		return false;
	}

	@Override
	public boolean validate(ValidationContext context, Object t) {
		Field f = context.getField();
		Length length = f.getAnnotation(Length.class);

		Object value = t;
		String result = null;

		int v = value.toString().length();
		if (v < length.min()) {
			result = f.getName() + "不得少于" + length.min() + "位";
		}
		if (v > length.max()) {
			result = f.getName() + "不得超过" + length.max() + "位";
		}
		if (result != null) {
			ValidationError validationError = new ValidationError();
			validationError.setField(f.getName());
			validationError.setErrorMsg(length.message().length() != 0 ? length.message() : result);
			validationError.setInvalidValue(value);
			context.addError(validationError);
			return false;
		}
		return true;
	}

}
