package com.xdja.framework.validation.validator.internal;

import java.lang.reflect.Field;

import com.xdja.framework.validation.annotation.Length;
import com.xdja.framework.validation.annotation.Number;
import com.xdja.framework.validation.annotation.Number.NumberType;
import com.xdja.framework.validation.validator.ValidationContext;
import com.xdja.framework.validation.validator.ValidationError;
import com.xdja.framework.validation.validator.Validator;

/**
 * 
 * @author  lvhao
 * @date    2019年6月21日 下午5:16:42
 * @version 1.0
 */
public class NumberValidator implements Validator<Object>{

	@Override
	public boolean accept(ValidationContext context, Object object) {
		if (object == null) {
			return false;
		}
		Field field = context.getField();
		com.xdja.framework.validation.annotation.Number number = field.getAnnotation(com.xdja.framework.validation.annotation.Number.class);
		if (number != null) {
			return true;
		}
		return false;
	}

	@Override
	public boolean validate(ValidationContext context, Object object) {
		Field f = context.getField();
		Number number = f.getAnnotation(com.xdja.framework.validation.annotation.Number.class);
		String result = null;
		try {
			if (number.type() == NumberType.BYTE) {
				long min = number.min();
				long max = number.max();
				if (min < Byte.MIN_VALUE) {
					throw new RuntimeException("验证定义错误，byte类型的min不得小于" + Byte.MIN_VALUE);
				}
				if (max > Byte.MAX_VALUE) {
					throw new RuntimeException("验证定义错误，byte类型的max不得超过" + Byte.MAX_VALUE);
				}
				
				byte value;
				if (object instanceof Byte) {
					value = (byte) object;
				} else {
					value = Byte.parseByte(String.valueOf(object));
				}
				
				if (value < min) {
					result = f.getName() + " 不得小于" + min;
				}
				if (value > max) {
					result = f.getName() + " 不得大于" + max;
				}
				
			}
		} catch (Exception e) {
			result = "无效数字";
		}
		if (result != null) {
			ValidationError validationError = new ValidationError();
			validationError.setField(f.getName());
			validationError.setErrorMsg(number.message().length() != 0 ? number.message() : result);
			validationError.setInvalidValue(object);
			context.addError(validationError);
			return false;
		}
		
		return false;
	}

}
