package com.xdja.framework.validation.validator.internal;

import java.lang.reflect.Field;
import java.util.regex.Matcher;

import com.xdja.framework.validation.annotation.Pattern;
import com.xdja.framework.validation.validator.ValidationContext;
import com.xdja.framework.validation.validator.ValidationError;
import com.xdja.framework.validation.validator.Validator;

public class PatternValidator implements Validator<Object>{

	@Override
	public boolean accept(ValidationContext context, Object t) {
		if(t == null){
			return false;
		}
		Field field = context.getField();
		Pattern pattern = field.getAnnotation(Pattern.class);
		if(pattern != null){
			return true;
		}
		return false;
	}

	@Override
	public boolean validate(ValidationContext context, Object t) {
		Field field = context.getField();
		Pattern annotation = field.getAnnotation(Pattern.class);
		String regexp = annotation.regexp();
		int intFlag = 0;
		for ( Pattern.Flag flag : annotation.flags() ) {
			intFlag = intFlag | flag.getValue();
		}
		java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(regexp, intFlag);

		String value = null;
		if(t instanceof String){
			value = (String) t;
		}else{
			value = String.valueOf(t);
		}
		
		Matcher matcher = pattern.matcher(value);
		if(!matcher.matches()){
			ValidationError validationError = new ValidationError();
			validationError.setField(field.getName());
			validationError.setErrorMsg(annotation.message());
			validationError.setInvalidValue(value);
			context.addError(validationError);
			return false;
		}
		
		return true;
	}

}
