package com.xdja.framework.validation.validator.internal;

import java.lang.reflect.Field;

import com.xdja.framework.validation.annotation.Size;
import com.xdja.framework.validation.validator.ValidationContext;
import com.xdja.framework.validation.validator.ValidationError;
import com.xdja.framework.validation.validator.Validator;

public class SizeValidator implements Validator<Object> {

	@Override
	public boolean accept(ValidationContext context, Object t) {
		if (t == null) {
			return false;
		}
		Field field = context.getField();
		Size size = field.getAnnotation(Size.class);
		if (size != null) {
			return true;
		}
		return false;
	}

	@Override
	public boolean validate(ValidationContext context, Object t) {

		Field f = context.getField();
		Size size = f.getAnnotation(Size.class);

		Object value = t;
		String result = null;

		try {
			int v = Integer.parseInt(value.toString());
			if (v < size.min()) {
				result = f.getName() + " 不得小于" + size.min();
			}
			if (v > size.max()) {
				result = f.getName() + " 不得大于" + size.max();
			}
		} catch (Exception e) {
			result = "无效数字";
		}
		if (result != null) {
			ValidationError validationError = new ValidationError();
			validationError.setField(f.getName());
			validationError.setErrorMsg(size.message().length() != 0 ? size.message() : result);
			validationError.setInvalidValue(value);
			context.addError(validationError);
			return false;
		}
		return true;
	}

}
