package com.xdja.framework.validation.validator.message;

import com.xdja.framework.validation.validator.ValidationContext;

/**
 * 消息模板中的filedName替换实际的字段名
 * 
 * @author lvhao
 *
 */
public class DefaultMessageInterpolator implements MessageInterpolator{

	@Override
	public String interpolate(String messageTemplate, ValidationContext context) {
		if (context.getField() != null && messageTemplate != null && messageTemplate.contains("{fieldName}")) {
			messageTemplate = messageTemplate.replaceAll("\\{fieldName\\}", context.getField().getName());
		}
		return messageTemplate;
	}

}
