/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck;

import com.xdja.healthcheck.bean.ServerCheckInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PackCheckResultUtil {
    private List<ServerCheckInfo.CheckDataBean> checkDataBeanList;
    private static final int DEFAULT_SIZE = 5;

    private PackCheckResultUtil() {
        this.checkDataBeanList = new ArrayList<ServerCheckInfo.CheckDataBean>(5);
    }

    private PackCheckResultUtil(List<ServerCheckInfo.CheckDataBean> checkDataBeans) {
        this.checkDataBeanList = checkDataBeans;
    }

    public static PackCheckResultUtil createInstance() {
        return new PackCheckResultUtil();
    }

    public static PackCheckResultUtil createInstance(List<ServerCheckInfo.CheckDataBean> list) {
        return new PackCheckResultUtil(list);
    }

    public PackCheckResultUtil addCheckDataBean(ServerCheckInfo.CheckDataBean checkDataBean) {
        this.checkDataBeanList.add(checkDataBean);
        return this;
    }

    public PackCheckResultUtil addCheckDataBeanList(List<ServerCheckInfo.CheckDataBean> checkDataBeans) {
        for (ServerCheckInfo.CheckDataBean ck : checkDataBeans) {
            if (ck.getCheckStatus() == 2) {
                this.checkDataBeanList.add(0, ck);
                continue;
            }
            this.checkDataBeanList.add(ck);
        }
        return this;
    }

    public PackCheckResultUtil addNormalCheckInfo(String checkType, String address, String configName) {
        ServerCheckInfo.CheckDataBean checkDataBean = new ServerCheckInfo.CheckDataBean();
        checkDataBean.setAddress(address);
        checkDataBean.setConfigName(configName);
        checkDataBean.setCheckStatus(1);
        checkDataBean.setCheckType(checkType);
        return this.addCheckDataBean(checkDataBean);
    }

    public PackCheckResultUtil addNormalCheckInfo(String checkType) {
        return this.addNormalCheckInfo(checkType, "", "");
    }

    public PackCheckResultUtil addErrorCheckInfo(String checkType, String address, String configName, String errorMsg, List<String> tips) {
        ServerCheckInfo.CheckDataBean checkDataBean = new ServerCheckInfo.CheckDataBean();
        checkDataBean.setCheckStatus(2);
        checkDataBean.setCheckType(checkType);
        checkDataBean.setErrorMsg(errorMsg);
        checkDataBean.setConfigName(configName);
        checkDataBean.setAddress(address);
        checkDataBean.setTips(tips);
        return this.addCheckDataBean(checkDataBean);
    }

    public PackCheckResultUtil addErrorCheckInfo(String checkType, String address, String configName, String errorMsg, String ... tips) {
        return this.addErrorCheckInfo(checkType, address, configName, errorMsg, (List<String>)(tips == null ? new ArrayList(0) : Arrays.asList(tips)));
    }

    public List<ServerCheckInfo.CheckDataBean> getCheckDataBeanList() {
        return this.checkDataBeanList;
    }
}

