/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.handler;

import com.xdja.healthcheck.bean.CheckResult;
import com.xdja.healthcheck.bean.State;
import com.xdja.healthcheck.util.CommonUtil;
import com.xdja.healthcheck.util.PTUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCheckHandler {
    private static final Logger log = LoggerFactory.getLogger(DBCheckHandler.class);

    public static CheckResult connCheck(String ip, String port, String dbName, String userName, String password, String instance, DBType dbType) {
        CheckResult checkResult = new CheckResult();
        String dbUrl = DBCheckHandler.getDbUrl(ip, port, dbName, instance, dbType);
        String dbDriver = DBCheckHandler.getDbDriver(dbType);
        if (dbDriver == null) {
            return new CheckResult("2", State.DBTYPE_ERROR);
        }
        long startTime = System.currentTimeMillis();
        boolean flag = DBCheckHandler.connDb(dbUrl, userName, password, dbDriver, dbType);
        if (flag) {
            checkResult.setFlag("1");
        } else {
            checkResult.setFlag("2");
            String[] ipAndPort = CommonUtil.fetchIpAndPort(dbUrl);
            if (ipAndPort == null) {
                checkResult.setState(State.DBURL_ERROR);
                checkResult.setMsg("\u6570\u636e\u5e93URL\u586b\u5199\u9519\u8bef");
            } else if (!PTUtil.telnet(ipAndPort[0], Integer.valueOf(ipAndPort[1]))) {
                checkResult.setState(State.TELNET_FAIL);
                checkResult.setMsg("telnet " + ipAndPort[0] + " " + ipAndPort[1] + "\u5931\u8d25");
            } else {
                checkResult.setState(State.UNKNOWN_ERROR);
                checkResult.setMsg("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25");
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        checkResult.setDuration(duration);
        checkResult.setCheckTitle("\u6570\u636e\u5e93");
        checkResult.setAddress(dbUrl);
        checkResult.setCheckType(dbType.name().toLowerCase());
        return checkResult;
    }

    public static CheckResult connCheck(String dbUrl, String userName, String password, DBType dbType) {
        CheckResult checkResult = new CheckResult();
        String dbDriver = DBCheckHandler.getDbDriver(dbType);
        if (dbDriver == null) {
            return new CheckResult("2", State.DBTYPE_ERROR);
        }
        long startTime = System.currentTimeMillis();
        boolean flag = DBCheckHandler.connDb(dbUrl, userName, password, dbDriver, dbType);
        if (flag) {
            checkResult.setFlag("1");
        } else {
            checkResult.setFlag("2");
            String[] ipAndPort = CommonUtil.fetchIpAndPort(dbUrl);
            if (ipAndPort == null) {
                checkResult.setState(State.DBURL_ERROR);
                checkResult.setMsg("\u6570\u636e\u5e93URL\u586b\u5199\u9519\u8bef");
            } else if (!PTUtil.telnet(ipAndPort[0], Integer.valueOf(ipAndPort[1]))) {
                checkResult.setState(State.TELNET_FAIL);
                checkResult.setMsg("telnet " + ipAndPort[0] + " " + ipAndPort[1] + "\u5931\u8d25");
            } else {
                checkResult.setState(State.UNKNOWN_ERROR);
                checkResult.setMsg("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25");
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        checkResult.setDuration(duration);
        checkResult.setCheckTitle("\u6570\u636e\u5e93\u670d\u52a1");
        checkResult.setAddress(dbUrl);
        checkResult.setCheckType(dbType.name().toLowerCase());
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connDb(String dbUrl, String userName, String password, String dbDriver, DBType dbType) {
        Connection connection = null;
        try {
            Class.forName(dbDriver);
            if (dbType == DBType.MYSQL) {
                dbUrl = dbUrl.contains("?") ? dbUrl + "&connectTimeout=30000&socketTimeout=60000" : dbUrl + "?connectTimeout=30000&socketTimeout=60000";
                connection = DriverManager.getConnection(dbUrl, userName, password);
            } else if (dbType == DBType.ORACLE) {
                Properties props = new Properties();
                props.put("user", userName);
                props.put("password", password);
                props.put("oracle.jdbc.ReadTimeout", (Object)3000L);
                connection = DriverManager.getConnection(dbUrl, props);
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1adbUrl:{},userName:{}", (Object)dbUrl, (Object)userName);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
        }
        return true;
    }

    private static String getDbDriver(DBType dbType) {
        String dbDriver = null;
        if (dbType == DBType.MYSQL) {
            dbDriver = "com.mysql.jdbc.Driver";
        } else if (dbType == DBType.ORACLE) {
            dbDriver = "oracle.jdbc.driver.OracleDriver";
        }
        return dbDriver;
    }

    public static String getDbUrl(String ip, String port, String dbName, String instance, DBType dbType) {
        String dbUrl = null;
        if (dbType == DBType.MYSQL) {
            dbUrl = "jdbc:mysql://" + ip + ":" + port + "/" + dbName;
        } else if (dbType == DBType.ORACLE) {
            instance = CommonUtil.isEmpty(instance) ? "ora11g" : instance;
            dbUrl = "jdbc:oracle:thin:@" + ip + ":" + port + ":" + instance;
        }
        return dbUrl;
    }

    public static enum DBType {
        MYSQL,
        ORACLE;

    }
}

