/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.handler;

import com.xdja.healthcheck.bean.CheckResult;
import com.xdja.healthcheck.bean.State;
import com.xdja.healthcheck.util.CommonUtil;
import com.xdja.healthcheck.util.PTUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCheckHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpCheckHandler.class);
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int ERROR_CODE = -1;

    public static CheckResult connCheck(String requestUrl) {
        int code;
        log.debug("http\u68c0\u6d4b\u8def\u5f84\u4e3arequestUrl\uff1a{}", (Object)requestUrl);
        CheckResult checkResult = new CheckResult();
        if (requestUrl == null || requestUrl.length() == 0) {
            checkResult.setFlag("2");
            checkResult.setState(State.PARAM_EMPTY);
        }
        long startTime = System.currentTimeMillis();
        String prefix = requestUrl.substring(0, 5);
        if ("http:".equalsIgnoreCase(prefix)) {
            code = HttpCheckHandler.connHttp(requestUrl);
        } else if ("https".equalsIgnoreCase(prefix)) {
            code = HttpCheckHandler.connHttps(requestUrl);
        } else {
            return new CheckResult("2", State.HTTP_ADDR_INVALID);
        }
        if (code != -1) {
            checkResult.setFlag("1");
            checkResult.setMsg(code + "");
        } else {
            checkResult.setFlag("2");
            String[] ipAndPort = CommonUtil.fetchIpAndPort(requestUrl);
            if (ipAndPort == null) {
                checkResult.setState(State.DBURL_ERROR);
                checkResult.setMsg("\u8bf7\u6c42URL\u586b\u5199\u9519\u8bef");
            } else if (!PTUtil.telnet(ipAndPort[0], Integer.valueOf(ipAndPort[1]))) {
                checkResult.setState(State.TELNET_FAIL);
                checkResult.setMsg("telnet " + ipAndPort[0] + " " + ipAndPort[1] + "\u5931\u8d25");
            } else {
                checkResult.setState(State.UNKNOWN_ERROR);
                checkResult.setMsg("http\u8bf7\u6c42\u5931\u8d25");
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        checkResult.setDuration(duration);
        checkResult.setDuration(duration);
        checkResult.setCheckTitle("\u4f9d\u8d56\u7b2c\u4e09\u65b9\u670d\u52a1");
        checkResult.setAddress(requestUrl);
        checkResult.setCheckType("http");
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int connHttp(String requestUrl) {
        HttpURLConnection conn = null;
        int code = -1;
        try {
            URL url = new URL(requestUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            code = conn.getResponseCode();
        }
        catch (Exception e) {
            log.error("http\u8bf7\u6c42{}\u5931\u8d25\uff1a{}", (Object)requestUrl, (Object)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int connHttps(String requestUrl) {
        HttpsURLConnection conn = null;
        int code = -1;
        try {
            conn = HttpCheckHandler.getHttpsURLConnection(requestUrl, "GET");
            conn.connect();
            code = conn.getResponseCode();
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5{}\u5931\u8d25\uff1a" + e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return code;
    }

    private static HttpsURLConnection getHttpsURLConnection(String uri, String method) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        SSLSocketFactory ssf = ctx.getSocketFactory();
        URL url = new URL(uri);
        HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
        httpsConn.setSSLSocketFactory(ssf);
        httpsConn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        });
        httpsConn.setRequestMethod(method);
        httpsConn.setConnectTimeout(3000);
        httpsConn.setDoInput(true);
        httpsConn.setDoOutput(true);
        return httpsConn;
    }

    private static final class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

