/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.handler;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.xdja.healthcheck.bean.CheckResult;
import com.xdja.healthcheck.bean.State;
import com.xdja.healthcheck.util.CommonUtil;
import com.xdja.healthcheck.util.PTUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQCheckHandler {
    private static final Logger log = LoggerFactory.getLogger(MQCheckHandler.class);

    public static CheckResult connCheck(String host, Integer port, String userName, String password) {
        CheckResult checkResult = new CheckResult();
        long startTime = System.currentTimeMillis();
        boolean flag = MQCheckHandler.connMQ(host, port, userName, password);
        if (flag) {
            checkResult.setFlag("1");
        } else {
            checkResult.setFlag("2");
            if (!CommonUtil.isCorrectIP(host)) {
                checkResult.setState(State.IP_ERROR);
                checkResult.setMsg("IP\u9519\u8bef");
            } else if (!CommonUtil.isCorrectPort(port)) {
                checkResult.setState(State.PORT_ERROR);
                checkResult.setMsg("port\u9519\u8bef");
            } else if (!PTUtil.telnet(host, port)) {
                checkResult.setState(State.TELNET_FAIL);
                checkResult.setMsg("telnet " + host + " " + port + "\u5931\u8d25");
            } else {
                checkResult.setState(State.UNKNOWN_ERROR);
                checkResult.setMsg("\u5176\u4ed6\u9519\u8bef");
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        checkResult.setDuration(duration);
        checkResult.setCheckTitle("\u6d88\u606f\u4e2d\u95f4\u4ef6");
        checkResult.setAddress("host:" + host + " port:" + port + " username:" + userName + " password:" + password);
        checkResult.setCheckType("rabbitmq");
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connMQ(String host, Integer port, String userName, String password) {
        Connection connection = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(host);
            factory.setPort(port.intValue());
            factory.setUsername(userName);
            factory.setPassword(password);
            factory.setConnectionTimeout(3000);
            connection = factory.newConnection();
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5MQ\u5931\u8d25\uff1amsg:{},host:{},port:{},userName:{}", new Object[]{e, host, port, userName});
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return true;
    }
}

