/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.handler;

import com.xdja.healthcheck.bean.CheckResult;
import com.xdja.healthcheck.bean.State;
import com.xdja.healthcheck.util.CommonUtil;
import com.xdja.healthcheck.util.PTUtil;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCheckHandler {
    private static final Logger log = LoggerFactory.getLogger(RedisCheckHandler.class);

    public static CheckResult connCheck(String host, int port) {
        return RedisCheckHandler.connCheck(host, port, null);
    }

    public static CheckResult connCheck(String host, int port, String password) {
        CheckResult checkResult = new CheckResult();
        long startTime = System.currentTimeMillis();
        boolean flag = RedisCheckHandler.connectRedis(host, port, password);
        if (flag) {
            checkResult.setFlag("1");
        } else {
            checkResult.setFlag("2");
            if (!CommonUtil.isCorrectIP(host)) {
                checkResult.setState(State.IP_ERROR);
                checkResult.setMsg("IP\u9519\u8bef");
            } else if (!CommonUtil.isCorrectPort(port)) {
                checkResult.setState(State.PORT_ERROR);
                checkResult.setMsg("port\u9519\u8bef");
            } else if (!PTUtil.telnet(host, port)) {
                checkResult.setState(State.TELNET_FAIL);
                checkResult.setMsg("telnet " + host + " " + port + "\u5931\u8d25");
            } else {
                checkResult.setState(State.UNKNOWN_ERROR);
                checkResult.setMsg("\u5176\u4ed6\u9519\u8bef");
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        checkResult.setDuration(duration);
        checkResult.setCheckTitle("\u5185\u5b58\u6570\u636e\u5e93");
        checkResult.setAddress("host:" + host + " port:" + port + " password:" + password);
        checkResult.setCheckType("redis");
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connectRedis(String host, int port, String password) {
        JedisPool jedisPool = null;
        try {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            jedisPool = password != null && !"".equals(password) ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 2000, password) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 2000);
            Jedis jedis = (Jedis)jedisPool.getResource();
            jedisPool.returnResource(jedis);
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5redis\u5931\u8d25\uff1a" + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (jedisPool != null) {
                jedisPool.destroy();
            }
        }
        return true;
    }
}

