/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
    private static final String COLON = ":";
    private static final String DEFAULT_PORT = "80";
    private static final String IP = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
    private static final String IP_DOT = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.";
    private static final String CORRECT_IP_REGEX = "^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)$";
    private static final String PORT = ":(\\d\\d\\d\\d\\d|\\d\\d\\d\\d|\\d\\d\\d|\\d\\d|\\d)";
    private static final String FETCH_IP_PORT_REGEX = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d):(\\d\\d\\d\\d\\d|\\d\\d\\d\\d|\\d\\d\\d|\\d\\d|\\d)";
    private static final String FETCH_IP_DEFAULT_PORT_REGEX = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";

    public static boolean isCorrectIP(String host) {
        Pattern pattern = Pattern.compile(CORRECT_IP_REGEX);
        return pattern.matcher(host).matches();
    }

    public static boolean isCorrectPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static String[] fetchIpAndPort(String url) {
        String expression = FETCH_IP_PORT_REGEX;
        expression = url.substring(6).indexOf(COLON) > 0 ? expression : FETCH_IP_DEFAULT_PORT_REGEX;
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(url);
        String[] ipAndPort = null;
        if (matcher.find()) {
            String group = matcher.group();
            ipAndPort = url.substring(6).indexOf(COLON) > 0 ? group.split(COLON) : new String[]{group, DEFAULT_PORT};
        }
        return ipAndPort;
    }

    public static boolean isEmpty(String str) {
        return "null".equalsIgnoreCase(str) || str == null || str.length() == 0 || 0 == str.replaceAll("\\s", "").length();
    }

    public static String getBasicUrl(String value) {
        char[] chars = value.toCharArray();
        int index = 0;
        int flag = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '/' || ++flag != 3) continue;
            index = i;
            break;
        }
        return index == 0 ? value : value.substring(0, index);
    }
}

