/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCUtils {
    private static final Logger log = LoggerFactory.getLogger(JDBCUtils.class);
    private static String dbDriver = "com.mysql.jdbc.Driver";
    private static String dbUrl = "jdbc:mysql://localhost:3306/store28";
    private static String dbUser = "root";
    private static String dbPassword = "root1234";

    private JDBCUtils() {
    }

    public static Connection getConnection() throws SQLException, ClassNotFoundException {
        Class.forName(dbDriver);
        return DriverManager.getConnection(dbUrl, dbUser, dbPassword);
    }

    public static void colseResource(Connection conn, Statement st, ResultSet rs) {
        JDBCUtils.closeResultSet(rs);
        JDBCUtils.closeStatement(st);
        JDBCUtils.closeConnection(conn);
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
        }
        conn = null;
    }

    public static void closeStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
        }
        st = null;
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
        }
        rs = null;
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("datasource.properties"));
            dbUrl = properties.getProperty("db.url");
            dbDriver = properties.getProperty("db.driverClassName");
            dbUser = properties.getProperty("db.username");
            dbPassword = properties.getProperty("db.password");
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u51fa\u9519\uff1a" + e);
        }
    }
}

