/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.healthcheck.util;

import com.xdja.healthcheck.util.CommonUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTUtil {
    public static final Integer DEFAULT_TIMEOUT = 3000;
    private static final Logger log = LoggerFactory.getLogger(PTUtil.class);

    public static boolean ping(String host) {
        return CommonUtil.isEmpty(host) ? false : PTUtil.ping(host, DEFAULT_TIMEOUT);
    }

    public static boolean ping(String host, Integer timeout) {
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.isReachable(timeout);
        }
        catch (IOException e) {
            log.error("ping faile--- host:{} errMsg{}", (Object)host, (Object)e.getMessage());
            return false;
        }
    }

    public static boolean telnet(String url) {
        if (CommonUtil.isEmpty(url)) {
            return false;
        }
        String[] ipAndPort = CommonUtil.fetchIpAndPort(url);
        return PTUtil.telnet(ipAndPort[0], Integer.parseInt(ipAndPort[1]), DEFAULT_TIMEOUT);
    }

    public static boolean telnet(String host, Integer port) {
        return PTUtil.telnet(host, port, DEFAULT_TIMEOUT);
    }

    public static boolean telnet(String host, Integer port, Integer timeout) {
        try {
            Socket server = new Socket();
            InetSocketAddress address = new InetSocketAddress(host, (int)port);
            server.connect(address, timeout);
            server.close();
        }
        catch (Exception e) {
            log.error("telnet faile--- host:{}, port:{} ,errMsg{}", new Object[]{host, port, e.getMessage()});
            return false;
        }
        return true;
    }
}

