/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.maven.plugin.verify;

import com.xdja.maven.plugin.verify.utils.MD5Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class VerifyMojo
extends AbstractMojo {
    private static final String[] FILETYPES_DEFAULT = new String[]{"war", "zip"};
    private static final String DOT = ".";
    private File buildDir;
    private String[] fileTypes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.fileTypes == null) {
            this.fileTypes = FILETYPES_DEFAULT;
        }
        if (!this.buildDir.exists()) {
            this.getLog().warn((CharSequence)(this.buildDir.getName() + " not exists"));
            return;
        }
        for (File file : this.buildDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return VerifyMojo.this.isSupportFile(name.toLowerCase());
            }
        })) {
            try {
                FileUtils.fileWrite((String)(file.getCanonicalPath() + ".MD5"), (String)MD5Util.getFileMD5String(file));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("\u8ba1\u7b97\u6587\u4ef6\uff1a" + file.getName() + "\u7684MD5\u503c\u51fa\u9519"), (Throwable)e);
            }
        }
    }

    private boolean isSupportFile(String name) {
        String fileType = null;
        int index = name.lastIndexOf(DOT);
        if (index > 0) {
            fileType = name.substring(index + 1).toLowerCase();
        }
        if (fileType != null) {
            return Arrays.binarySearch(this.fileTypes, fileType) > -1;
        }
        return false;
    }
}

