/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.maven.plugin.verify.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static MessageDigest messageDigest = null;

    public static String getFileMD5String(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        FileChannel fch = in.getChannel();
        MappedByteBuffer byteBuffer = fch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        messageDigest.update(byteBuffer);
        return MD5Util.bufferToHex(messageDigest.digest());
    }

    private static String bufferToHex(byte[] bytes) {
        return MD5Util.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer sb = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            MD5Util.appendHexPair(bytes[l], sb);
        }
        return sb.toString();
    }

    private static void appendHexPair(byte b, StringBuffer sb) {
        char c0 = hexDigits[(b & 0xF0) >> 4];
        char c1 = hexDigits[b & 0xF];
        sb.append(c0);
        sb.append(c1);
    }

    static {
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(MD5Util.class.getName() + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util\u3002");
            e.printStackTrace();
        }
    }
}

