/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.operation.system.dao;

import com.xdja.operation.system.bean.Function;
import java.util.List;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.annotation.Result;
import org.jfaster.mango.annotation.Results;
import org.jfaster.mango.annotation.ReturnGeneratedId;
import org.jfaster.mango.annotation.SQL;

@DB(name="operation", table="t_sys_func")
@Results(value={@Result(column="n_id", property="id"), @Result(column="c_name", property="name"), @Result(column="c_icon", property="icon"), @Result(column="n_pid", property="pid"), @Result(column="n_order", property="order"), @Result(column="c_url", property="url"), @Result(column="c_permission", property="permission")})
public interface FunctionDao {
    public static final String COLUMNS = "n_id, c_name, c_icon, n_pid, n_order, c_url, c_permission";

    @ReturnGeneratedId
    @SQL(value="insert into #table(n_id, c_name, c_icon, n_pid, n_order, c_url, c_permission) values(:id, :name, :icon, :pid, :order, :url, :permission)")
    public int addFunction(Function var1);

    @SQL(value="select n_id, c_name, c_icon, n_pid, n_order, c_url, c_permission from #table where n_id = :1")
    public Function getFunction(int var1);

    @SQL(value="select DISTINCT f.n_id, f.c_name, f.c_icon, f.n_pid, f.n_order, f.c_url, f.c_permission from t_sys_user_role ur join t_sys_role_func rf on ur.n_role_id = rf.n_role_id join t_sys_func f on rf.n_func_id = f.n_id where ur.n_user_id = :1 order by n_pid asc, n_order asc")
    public List<Function> queryFuncsByUserId(int var1);

    @SQL(value="select f.n_id, f.c_name, f.c_icon, f.n_pid, f.n_order, f.c_url, f.c_permission from t_sys_func f where f.n_pid=:1")
    public List<Function> queryFuncsByPid(int var1);

    @SQL(value="select f.c_permission from t_sys_user_role ur join t_sys_role_func rf on ur.n_role_id = rf.n_role_id join t_sys_func f on rf.n_func_id = f.n_id where ur.n_user_id = :1 and f.c_permission is not null order by n_pid asc, n_order asc")
    public List<String> queryPermissionByUserId(int var1);

    @SQL(value="update #table set c_name=:name, c_icon=:icon, n_pid=:pid, n_order=:order, c_url=:url, c_permission=:permission where n_id = :id")
    public boolean updateFunction(Function var1);

    @SQL(value="delete from #table where n_id = :1")
    public boolean deleteFunction(int var1);

    @SQL(value="select n_id, c_name, c_icon, n_pid, n_order, c_url, c_permission from #table order by n_pid asc, n_order asc")
    public List<Function> queryAll();
}

