/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.operation.system.service;

import com.xdja.operation.page.Pagination;
import com.xdja.operation.system.bean.AppMenu;
import com.xdja.operation.system.dao.AppDao;
import com.xdja.operation.system.dao.CompanyAppDao;
import com.xdja.operation.system.service.IAppService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfaster.mango.plugin.page.Page;
import org.jfaster.mango.transaction.TransactionAction;
import org.jfaster.mango.transaction.TransactionStatus;
import org.jfaster.mango.transaction.TransactionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppServiceImpl
implements IAppService {
    @Autowired
    private AppDao dao;
    @Autowired
    private CompanyAppDao companyAppDao;

    public long save(AppMenu object) {
        object.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        object.setDeleteFlag(0);
        object.setStatus(1);
        return this.dao.save(object);
    }

    public boolean countByLoginName(String name) {
        return this.dao.countByLoginName(name) > 0;
    }

    public boolean countBySn(String sn) {
        return this.dao.countBySn(sn) > 0;
    }

    public void update(AppMenu object) {
        this.dao.update(object);
    }

    public Map<String, Object> count() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nativeSize", this.dao.appsCount(1));
        map.put("H5Size", this.dao.appsCount(2));
        map.put("apkSize", this.dao.appsCount(3));
        return map;
    }

    public void updateDeleteFlag(final Long id) {
        TransactionTemplate.execute((String)"eoa", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus transactionStatus) {
                AppServiceImpl.this.companyAppDao.deleteByMenuId(id);
                AppServiceImpl.this.dao.updateDeleteFlag(id);
            }
        });
    }

    public AppMenu get(Long id) {
        return this.dao.get(id);
    }

    public Boolean isUse(Long menuId) {
        if (this.dao.isUse(menuId) > 0) {
            return true;
        }
        return false;
    }

    public Pagination listPage(String name, Integer type0, Integer type1, Integer type2, int pageNo, int pageSize) {
        Pagination pagination = new Pagination();
        Page page = Page.create((int)pageNo, (int)pageSize);
        List<AppMenu> list = this.dao.list(name, type0, type1, type2, page);
        pagination.setList(list);
        pagination.setTotal(page.getTotal());
        return pagination;
    }

    public List<AppMenu> list() {
        return this.dao.list();
    }

    public List<AppMenu> companyAppList(Long companyId) {
        return this.dao.companyAppList(companyId);
    }
}

