/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.operation.system.service;

import com.xdja.operation.page.Pagination;
import com.xdja.operation.system.bean.CompanyAdmin;
import com.xdja.operation.system.dao.CompanyAdminDao;
import com.xdja.operation.system.service.CompanyAdminService;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CompanyAdminServiceImpl
implements CompanyAdminService {
    @Autowired
    private CompanyAdminDao dao;

    public Pagination list(String search, Integer pageNo, Integer pageSize) {
        Pagination pagination = new Pagination();
        Page page = Page.create((int)pageNo, (int)pageSize);
        List<CompanyAdmin> adminList = this.dao.list(search, page);
        pagination.setList(adminList);
        pagination.setTotal(page.getTotal());
        return pagination;
    }

    public CompanyAdmin getDetail(Long companyId) {
        return this.dao.getDetail(companyId);
    }

    public Boolean countByLoginName(CompanyAdmin companyAdmin) {
        if (this.dao.countByLoginName(companyAdmin) > 0) {
            return true;
        }
        return false;
    }

    public int countByCompanyId(Long companyId) {
        return this.dao.countByCompanyId(companyId);
    }

    public void add(CompanyAdmin companyAdmin, String password) {
        companyAdmin.setPassword(password);
        companyAdmin.setAdminFlag(1);
        companyAdmin.setStatus(1);
        companyAdmin.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        this.dao.add(companyAdmin);
    }

    public void edit(CompanyAdmin companyAdmin) {
        companyAdmin.setModifyTime(Long.valueOf(System.currentTimeMillis()));
        this.dao.edit(companyAdmin);
    }

    public void delete(Long id) {
        this.dao.delete(id);
    }

    public void resetPwd(Long id, String password) {
        Long time = System.currentTimeMillis();
        this.dao.resetPwd(id, password, time);
    }
}

