/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.operation.system.service;

import com.alibaba.fastjson.JSONObject;
import com.xdja.operation.page.Pagination;
import com.xdja.operation.system.bean.Company;
import com.xdja.operation.system.bean.CompanyFileserver;
import com.xdja.operation.system.bean.Dept;
import com.xdja.operation.system.bean.Menu;
import com.xdja.operation.system.dao.CompanyDao;
import com.xdja.operation.system.dao.DeptDao;
import com.xdja.operation.system.dao.ICompanyFileserverDao;
import com.xdja.operation.system.dao.MenuDao;
import com.xdja.operation.system.service.CompanyService;
import com.xdja.operation.util.ConfigLoadSystem;
import com.xdja.operation.util.HmacSha1;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jfaster.mango.plugin.page.Page;
import org.jfaster.mango.transaction.TransactionAction;
import org.jfaster.mango.transaction.TransactionStatus;
import org.jfaster.mango.transaction.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CompanyServiceImpl
implements CompanyService {
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private DeptDao deptDao;
    @Autowired
    private MenuDao menuDao;
    @Autowired
    private ICompanyFileserverDao iCompanyFileserverDao;

    public Long addCompany(final Company company) {
        company.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        company.setModifyTime(Long.valueOf(System.currentTimeMillis()));
        TransactionTemplate.execute((String)"eoa", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus transactionStatus) {
                String fileServerReturnJsonStr;
                long companyId;
                block15: {
                    Menu companyById;
                    companyId = CompanyServiceImpl.this.companyDao.addCompany(company);
                    boolean value = ConfigLoadSystem.getBoolean((String)"DEPT.PARENT");
                    if (value) {
                        Dept dept = new Dept();
                        dept.setName(company.getName());
                        dept.setVersion(Long.valueOf(1L));
                        dept.setCreateTime(Long.valueOf(System.currentTimeMillis()));
                        dept.setParentId(Long.valueOf(0L));
                        dept.setDeleteFlag(Integer.valueOf(0));
                        dept.setCompanyId(Long.valueOf(companyId));
                        if (dept.getSort() == null || dept.getSort() <= 0L) {
                            dept.setSort(Long.valueOf(9999L));
                        } else {
                            dept.setSort(dept.getSort());
                        }
                        Long deptId = CompanyServiceImpl.this.deptDao.addDept(dept);
                        String code = "" + deptId;
                        CompanyServiceImpl.this.deptDao.updateCodeByDeptId(deptId, code);
                    }
                    if ((companyById = CompanyServiceImpl.this.menuDao.getCompanyById(companyId)) == null) {
                        String menus = ConfigLoadSystem.getStringValue((String)"OA.MENU");
                        String[] split = null;
                        if (StringUtils.hasLength((String)menus)) {
                            split = menus.split(";");
                        }
                        if (split != null && split.length > 0) {
                            String[] stringArray = split;
                            int n = split.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String s = stringArray[n2];
                                String[] split1 = s.split(" ");
                                Long parentId = null;
                                int i = 0;
                                while (i < split1.length) {
                                    String[] split2 = split1[i].split("@");
                                    if (i == 0) {
                                        Menu parentMenu = new Menu();
                                        parentMenu.setName(split2[0]);
                                        parentMenu.setParentId(Long.valueOf(0L));
                                        parentMenu.setStatus(Integer.valueOf(1));
                                        parentMenu.setCompanyId(Long.valueOf(companyId));
                                        parentMenu.setCreateTime(Long.valueOf(System.currentTimeMillis()));
                                        parentMenu.setSort(split2[2]);
                                        parentId = CompanyServiceImpl.this.menuDao.save(parentMenu);
                                    } else {
                                        Menu menu = new Menu();
                                        menu.setParentId(parentId);
                                        menu.setCompanyId(Long.valueOf(companyId));
                                        menu.setStatus(Integer.valueOf(1));
                                        menu.setName(split2[0]);
                                        menu.setUrl(split2[1]);
                                        menu.setSort(split2[2]);
                                        menu.setCreateTime(Long.valueOf(System.currentTimeMillis()));
                                        CompanyServiceImpl.this.menuDao.save(menu);
                                    }
                                    ++i;
                                }
                                ++n2;
                            }
                        }
                    }
                    String url = ConfigLoadSystem.getStringValue((String)"FILE_SERVER_URL");
                    Long ts = System.currentTimeMillis() + 600000L;
                    String appid = ConfigLoadSystem.getStringValue((String)"FILE_OA_APPID");
                    String appsecret = ConfigLoadSystem.getStringValue((String)"FILE_OA_APPSECRET");
                    fileServerReturnJsonStr = null;
                    try {
                        String name = company.getName();
                        String sign = HmacSha1.hamcsha1((String)(String.valueOf(name) + ts + appid), (String)appsecret);
                        CompanyServiceImpl.this.LOG.debug("\u8bf7\u6c42\u6587\u4ef6\u670d\u52a1\u5668\u53c2\u6570\uff1aname={}, ts={}, appid={}, sign={}", new Object[]{name, ts, appid, sign});
                        DefaultHttpClient client = new DefaultHttpClient();
                        HttpGet get = new HttpGet(String.valueOf(url) + "/addUser?name=" + name + "&ts=" + ts + "&appid=" + appid + "&sign=" + sign);
                        HttpResponse response = client.execute((HttpUriRequest)get);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            HttpEntity entity = response.getEntity();
                            if (entity != null) {
                                fileServerReturnJsonStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                            }
                            break block15;
                        }
                        throw new IllegalArgumentException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5668\u6dfb\u52a0\u7528\u6237\u5f02\u5e38");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5668\u6dfb\u52a0\u7528\u6237\u5f02\u5e38");
                    }
                }
                if (!StringUtils.isEmpty(fileServerReturnJsonStr)) {
                    CompanyFileserver cfs = (CompanyFileserver)JSONObject.parseObject((String)fileServerReturnJsonStr, CompanyFileserver.class);
                    cfs.setCompanyId(Long.valueOf(companyId));
                    cfs.setDeleteFlag(0);
                    CompanyServiceImpl.this.iCompanyFileserverDao.save(cfs);
                }
            }
        });
        return 1L;
    }

    public Company getCompany(Long id) {
        return this.companyDao.getCompany(id);
    }

    public boolean updateCompany(Company company) {
        company.setModifyTime(Long.valueOf(System.currentTimeMillis()));
        return this.companyDao.updateCompany(company);
    }

    public boolean deleteCompany(long id) {
        return this.companyDao.deleteCompany(id);
    }

    public Pagination companyList(Long id, Integer pageNo, Integer pageSize) {
        Page page = Page.create((int)pageNo, (int)pageSize);
        List<Company> companies = this.companyDao.companyList(id, page);
        Pagination pagination = new Pagination();
        pagination.setList(companies);
        pagination.setTotal(page.getTotal());
        return pagination;
    }

    public List<Company> searchCompayList(String name) {
        List<Company> companyList = this.companyDao.searchCompayList(name);
        if (companyList != null && companyList.size() > 0) {
            for (Company company : companyList) {
                if (!company.getName().contains(name)) continue;
                String frontCompanyName = company.getName().replaceAll(name, String.valueOf(ConfigLoadSystem.getStringValue((String)"HIGHLIGHT_STYLE_START")) + name + ConfigLoadSystem.getStringValue((String)"HIGHLIGHT_STYLE_END"));
                company.setCompanyNameHighlight(frontCompanyName);
            }
        }
        return companyList;
    }

    public boolean stopCompany(int status, Long id) {
        return this.companyDao.stopCompany(status, id);
    }
}

