/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.operation.system.service;

import com.xdja.operation.page.Pagination;
import com.xdja.operation.system.bean.Role;
import com.xdja.operation.system.bean.RoleFunc;
import com.xdja.operation.system.dao.RoleDao;
import com.xdja.operation.system.service.RoleService;
import com.xdja.operation.util.ConfigLoadSystem;
import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.jfaster.mango.transaction.TransactionAction;
import org.jfaster.mango.transaction.TransactionStatus;
import org.jfaster.mango.transaction.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class RoleServiceImpl
implements RoleService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RoleDao dao;

    public void add(final Role role, final List<Integer> funcs) {
        TransactionTemplate.execute((String)"operation", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus status) {
                int roleId = RoleServiceImpl.this.dao.addRole(role);
                ArrayList<RoleFunc> list = new ArrayList<RoleFunc>();
                for (Integer funcId : funcs) {
                    RoleFunc rf = new RoleFunc(Integer.valueOf(roleId), funcId);
                    list.add(rf);
                }
                RoleServiceImpl.this.dao.addRoleFuncs(list);
            }
        });
    }

    public void update(final Role role, final List<Integer> funcs) {
        TransactionTemplate.execute((String)"operation", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus status) {
                RoleServiceImpl.this.dao.updateRole(role);
                RoleServiceImpl.this.dao.deleteRoleFunc(role.getId());
                ArrayList<RoleFunc> list = new ArrayList<RoleFunc>();
                for (Integer funcId : funcs) {
                    RoleFunc rf = new RoleFunc(role.getId(), funcId);
                    list.add(rf);
                }
                RoleServiceImpl.this.dao.addRoleFuncs(list);
            }
        });
    }

    public void del(final int id) {
        TransactionTemplate.execute((String)"operation", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus status) {
                RoleServiceImpl.this.dao.deleteRoleFunc(id);
                RoleServiceImpl.this.dao.deleteRole(id);
            }
        });
    }

    public List<Integer> getRoleFunc(int id) {
        return this.dao.getRoleFunc(id);
    }

    public Role getRoleByName(String name, Integer id) {
        return this.dao.getRoleByName(name, id);
    }

    public void update(Role role) {
        this.dao.updateRole(role);
    }

    public Role get(int id) {
        return this.dao.getRole(id);
    }

    public List<Role> list(Long id, String search) {
        List<Role> list = this.dao.list(id, search);
        if (!StringUtils.isEmpty((Object)search)) {
            for (Role role : list) {
                if (!role.getName().contains(search)) continue;
                String frontCompanyName = role.getName().replaceAll(search, String.valueOf(ConfigLoadSystem.getStringValue((String)"HIGHLIGHT_STYLE_START")) + search + ConfigLoadSystem.getStringValue((String)"HIGHLIGHT_STYLE_END"));
                role.setRoleNameHighlight(frontCompanyName);
            }
        }
        return list;
    }

    public Pagination listPage(Long id, String search, Integer pageNum, Integer pageSize) {
        Page page = Page.create((int)pageNum, (int)pageSize);
        Pagination pagination = new Pagination();
        pagination.setList(this.dao.listPage(id, search, page));
        pagination.setTotal(page.getTotal());
        return pagination;
    }
}

