/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.operation.system.service;

import com.xdja.operation.httpbean.ResponseBean;
import com.xdja.operation.page.Pagination;
import com.xdja.operation.system.bean.Function;
import com.xdja.operation.system.bean.User;
import com.xdja.operation.system.bean.UserRole;
import com.xdja.operation.system.dao.FunctionDao;
import com.xdja.operation.system.dao.UserDao;
import com.xdja.operation.system.service.UserService;
import com.xdja.operation.util.ConfigLoadSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.jfaster.mango.transaction.TransactionAction;
import org.jfaster.mango.transaction.TransactionStatus;
import org.jfaster.mango.transaction.TransactionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private FunctionDao funcDao;

    public User queryByAccountAndPwd(String account, String password) {
        User user = this.userDao.queryByAccountAndPwd(account, password);
        if (user != null) {
            List<String> permissions = this.funcDao.queryPermissionByUserId(user.getId());
            user.setPermissions(permissions);
        }
        return user;
    }

    public List<Function> queryFuncs(int userId, int type) {
        List<Function> roots = this.funcDao.queryFuncsByPid(0);
        HashMap<Integer, Function> rootMap = new HashMap<Integer, Function>();
        for (Function root : roots) {
            rootMap.put(root.getId(), root);
        }
        List<Function> funcs = null;
        funcs = 2 == type ? this.funcDao.queryFuncsByUserId(userId) : this.funcDao.queryAll();
        HashMap<Integer, Function> funcMap = new HashMap<Integer, Function>();
        ArrayList<Function> result = new ArrayList<Function>();
        for (Function func : funcs) {
            ArrayList<Function> children;
            if (func.getPid() == 0) {
                funcMap.put(func.getId(), func);
                result.add(func);
                continue;
            }
            Function parent = (Function)funcMap.get(func.getPid());
            if (parent == null) {
                parent = (Function)rootMap.get(func.getPid());
                funcMap.put(func.getPid(), parent);
                result.add(parent);
            }
            if ((children = parent.getChild()) == null) {
                children = new ArrayList<Function>();
                parent.setChild(children);
            }
            children.add(func);
        }
        return result;
    }

    public boolean isPwdEquals(int userId, String pwd) {
        User user = this.userDao.getUser(userId);
        if (user == null) {
            return false;
        }
        return user.getPwd().equals(pwd);
    }

    public void changePwd(int userId, String pwd) {
        this.userDao.changePwd(userId, pwd);
    }

    public Pagination queryUsers(Long id, int type, Integer pageNum, Integer pageSize) {
        Page page = Page.create((int)pageNum, (int)pageSize);
        Pagination pagination = new Pagination();
        pagination.setList(this.userDao.query(id, type, page));
        pagination.setTotal(page.getTotal());
        return pagination;
    }

    public List<User> search(String search) {
        List<User> search1 = this.userDao.search(search);
        if (!StringUtils.isEmpty((Object)search)) {
            for (User user : search1) {
                if (!user.getName().contains(search)) continue;
                String frontCompanyName = user.getName().replaceAll(search, String.valueOf(ConfigLoadSystem.getStringValue((String)"HIGHLIGHT_STYLE_START")) + search + ConfigLoadSystem.getStringValue((String)"HIGHLIGHT_STYLE_END"));
                user.setUserNameHighlight(frontCompanyName);
            }
        }
        return search1;
    }

    public boolean resetPwd(int userId, String pwd) {
        return this.userDao.updatePwd(userId, pwd);
    }

    public boolean disable(int userId) {
        return this.userDao.updateStatus(userId, 2);
    }

    public boolean enable(int userId) {
        return this.userDao.updateStatus(userId, 1);
    }

    public ResponseBean add(final User user) {
        int exists = this.userDao.accountExist(user.getAccount());
        if (exists > 0) {
            return ResponseBean.createError((String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362");
        }
        TransactionTemplate.execute((String)"operation", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus status) {
                int userId = UserServiceImpl.this.userDao.addUser(user);
                ArrayList<UserRole> list = new ArrayList<UserRole>();
                for (Integer roleId : user.getRoles()) {
                    UserRole ur = new UserRole(Integer.valueOf(userId), roleId);
                    list.add(ur);
                }
                UserServiceImpl.this.userDao.saveUserRole(list);
            }
        });
        return ResponseBean.createSuccess(null);
    }

    public List<Integer> queryUserRoles(int userId) {
        return this.userDao.queryUserRoles(userId);
    }

    public void edit(final User user) {
        TransactionTemplate.execute((String)"operation", (TransactionAction)new TransactionAction(){

            public void doInTransaction(TransactionStatus status) {
                UserServiceImpl.this.userDao.updateUser(user);
                UserServiceImpl.this.userDao.clearUserRoles(user.getId());
                ArrayList<UserRole> list = new ArrayList<UserRole>();
                for (Integer roleId : user.getRoles()) {
                    UserRole ur = new UserRole(user.getId(), roleId);
                    list.add(ur);
                }
                UserServiceImpl.this.userDao.saveUserRole(list);
            }
        });
    }

    public User getUser(int id) {
        return this.userDao.getUser(id);
    }
}

