/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.xdja.pams.common.data.ResponseData;
import com.xdja.pams.common.data.ResponseDataList;
import com.xdja.pams.common.data.ResponseDataObject;
import com.xdja.pams.common.util.Page;
import java.util.List;

public class Response {
    private String code;
    private String msg;
    private Integer pagesize;
    private Integer page;
    private Integer total;
    private Object rows;
    private Class<?> dataType;

    public Response() {
    }

    public Response(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Response(String code, String msg, Object rows) {
        this.code = code;
        this.msg = msg;
        this.rows = rows;
    }

    public Response(String code, String msg, Integer pagesize, Integer page, Integer total, Object rows) {
        this.code = code;
        this.msg = msg;
        this.pagesize = pagesize;
        this.page = page;
        this.total = total;
        this.rows = rows;
    }

    public <T> ResponseData<T> build() {
        ResponseData result = new ResponseData();
        if (this.rows instanceof List) {
            List list = (List)this.rows;
            if (!list.isEmpty()) {
                this.buildDataList(result);
            } else {
                this.buildDataObject(result);
            }
        } else {
            this.buildDataObject(result);
        }
        return result;
    }

    private <T> void buildDataList(ResponseData<T> result) {
        ResponseDataList object = new ResponseDataList();
        List temp = (List)this.rows;
        object.setCode(this.code);
        if (this.total == null) {
            object.setTotal(temp.size());
        } else {
            object.setTotal(this.total);
        }
        object.setRows((List)this.rows);
        object.setMsg(this.msg);
        object.setPage(this.page);
        object.setPageSize(this.pagesize);
        result.setDataList(object);
        result.setList(true);
        this.setDataType(temp.get(0).getClass());
    }

    private <T> void buildDataObject(ResponseData<T> result) {
        ResponseDataObject<Object> object = new ResponseDataObject<Object>();
        object.setCode(this.code);
        object.setTotal(this.total);
        object.setRows(this.rows);
        object.setMsg(this.msg);
        object.setPage(this.page);
        object.setPageSize(this.pagesize);
        result.setDataObject(object);
        if (this.rows == null) {
            this.setDataType(String.class);
        } else {
            this.setDataType(this.rows.getClass());
        }
    }

    public static Response successMsg(String msg) {
        return new Response("0", msg, null);
    }

    public static Response successData(Object data) {
        return Response.successData(data, null);
    }

    public static Response successData(Object data, Page page) {
        Response response = new Response("0", "\u64cd\u4f5c\u6210\u529f", data);
        if (page != null) {
            response.setTotal(page.getTotal());
            response.setPage(page.getPage());
            response.setPagesize(page.getRp());
        }
        return response;
    }

    public static Response failMsg(String msg) {
        return new Response("1", msg, null);
    }

    public static Response failData(Object data) {
        return new Response("1", "\u64cd\u4f5c\u5931\u8d25", data);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(Integer pagesize) {
        this.pagesize = pagesize;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Object getRows() {
        return this.rows;
    }

    public void setRows(Object rows) {
        this.rows = rows;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(Class<?> dataType) {
        this.dataType = dataType;
    }
}

