/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xdja.pams.common.data.ResponseBean;
import com.xdja.pams.common.data.ResponseData;
import com.xdja.pams.common.data.ResponseDataList;
import com.xdja.pams.common.data.ResponseDataObject;
import com.xdja.pams.util.JsonParserUtils;
import java.util.HashMap;

public class ResponseParserUtils {
    public static ResponseBean toResponseBean(String json) {
        JsonElement totalElement;
        ResponseBean data = new ResponseBean();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        data.setCode(jsonObject.get("code").getAsString());
        data.setMsg(jsonObject.get("msg").getAsString());
        JsonElement element = jsonObject.get("rows");
        if (element != null) {
            data.setRows(element.toString());
        }
        if ((totalElement = jsonObject.get("total")) != null) {
            data.setTotal(totalElement.getAsString());
        }
        data.setContent(json);
        return data;
    }

    public static <T> ResponseData<T> fromJson(String json, Class<T> clazz) {
        ResponseData<T> data = new ResponseData<T>();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        JsonElement dataJson = jsonObject.get("rows");
        if (dataJson == null) {
            ResponseDataObject dataObject = new ResponseDataObject();
            dataObject.setCode(jsonObject.get("code").getAsString());
            dataObject.setMsg(jsonObject.get("msg").getAsString());
            data.setDataObject(dataObject);
            return data;
        }
        if (dataJson.isJsonArray()) {
            ResponseDataList<T> list = ResponseParserUtils.fromJsonList(json, clazz);
            data.setList(true);
            data.setDataList(list);
        } else if (dataJson.isJsonObject()) {
            ResponseDataObject<T> object = ResponseParserUtils.fromJsonObject(json, clazz);
            data.setDataObject(object);
        }
        return data;
    }

    public static ResponseData<HashMap> fromJsonToMap(String json) {
        return ResponseParserUtils.fromJson(json, HashMap.class);
    }

    public static <T> ResponseDataList<T> fromJsonList(String json, Class<T> clazz) {
        return (ResponseDataList)JsonParserUtils.fromJson(json, ResponseDataList.class, clazz);
    }

    public static <T> ResponseDataObject<T> fromJsonObject(String json, Class<T> clazz) {
        return (ResponseDataObject)JsonParserUtils.fromJson(json, ResponseDataObject.class, clazz);
    }

    public static <T> String toJson(Object json, Class<T> clazz, boolean isList) {
        if (isList) {
            return ResponseParserUtils.toJsonList(json, clazz);
        }
        return ResponseParserUtils.toJsonObject(json, clazz);
    }

    public static <T> String toJson(ResponseData<T> json, Class<T> clazz) {
        if (json.isList()) {
            return ResponseParserUtils.toJsonList(json.getDataList(), clazz);
        }
        return ResponseParserUtils.toJsonObject(json.getDataObject(), clazz);
    }

    public static <T> String toJsonList(Object json, Class<T> clazz) {
        return JsonParserUtils.toJson(json, ResponseDataList.class, clazz);
    }

    public static <T> String toJsonObject(Object json, Class<T> clazz) {
        return JsonParserUtils.toJson(json, ResponseDataObject.class, clazz);
    }
}

