/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xdja.pams.common.data.RequestBean;
import com.xdja.pams.common.data.RequestData;
import com.xdja.pams.common.util.Request;
import com.xdja.pams.common.util.RequestParserUtils;
import com.xdja.pams.util.JsonParserUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class RequestApi {
    private static final String CHARSET_NAME = "UTF-8";
    private String url;

    public RequestApi(String url) {
        this.url = url;
    }

    public RequestApi(String baseUrl, String action) {
        this.url = this.getRequestURL(baseUrl, action);
    }

    private String getRequestURL(String baseUrl, String action) {
        boolean isEndWithSlash = baseUrl.endsWith("/");
        StringBuilder sb = new StringBuilder(baseUrl);
        boolean commandStartWithSlash = action.startsWith("/");
        if (isEndWithSlash ^ commandStartWithSlash) {
            sb.append(action);
        } else if (isEndWithSlash) {
            sb.append(action.substring(1));
        } else {
            sb.append("/").append(action);
        }
        return sb.toString();
    }

    public String post(String data) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.url);
        post.setHeader("Content-type", "application/x-www-form-urlencoded");
        StringEntity entity = new StringEntity(RequestApi.makeParameters(data), CHARSET_NAME);
        post.setEntity((HttpEntity)entity);
        String responseContent = null;
        HttpResponse response = null;
        response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity httpEntity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET_NAME);
        }
        client.getConnectionManager().shutdown();
        return responseContent;
    }

    public <T> String post(RequestData<T> request, Class<T> clazz) throws Exception {
        String json = RequestParserUtils.toJson(request, clazz);
        return this.post(json);
    }

    public <T> String post(Request request) throws Exception {
        RequestData data = request.build();
        String json = RequestParserUtils.toJson(data, data.getClass());
        return this.post(json);
    }

    public static String getParameters(HttpServletRequest request) {
        return request.getParameter("_params");
    }

    public static String makeParameters(String parameters) {
        return "_params=" + parameters;
    }

    public static RequestBean toRequestBean(String json) {
        return RequestParserUtils.toRequestBean(json);
    }

    public static String toJsonPage(String json, String page, String pageSize) {
        if (StringUtils.isNotBlank((CharSequence)page) || StringUtils.isNotBlank((CharSequence)pageSize)) {
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(json).getAsJsonObject();
            jsonObject.addProperty("page", page);
            jsonObject.addProperty("pageSize", pageSize);
            return JsonParserUtils.gson().toJson((JsonElement)jsonObject);
        }
        return json;
    }
}

