/*
 * Decompiled with CFR 0.152.
 */
package pams.function.common.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import pams.function.common.init.ScheduleClass;
import pams.function.common.util.SpringUtils;

@Service
public class AllInitSchedule {
    private static final Logger logger = LoggerFactory.getLogger(AllInitSchedule.class);
    private static final List<String> hasExecClass = new ArrayList<String>();
    @Autowired
    private Scheduler scheduler;

    @Scheduled(fixedDelay=10000L)
    public void exec() {
        Map scheduleObject = SpringUtils.getBeansByClass(ScheduleClass.class);
        Set keys = scheduleObject.keySet();
        if (keys != null) {
            for (String key : keys) {
                ScheduleClass scheduleClass = (ScheduleClass)scheduleObject.get(key);
                if (!scheduleClass.isOpen()) {
                    if (!hasExecClass.contains(key)) continue;
                    try {
                        TriggerKey triggerKey = TriggerKey.triggerKey((String)this.getTriggerName(key), (String)this.getTriggerGroupName(key));
                        this.scheduler.pauseTrigger(triggerKey);
                        this.scheduler.unscheduleJob(triggerKey);
                        this.scheduler.deleteJob(JobKey.jobKey((String)this.getJobName(key), (String)this.getJobGroupName(key)));
                        hasExecClass.remove(key);
                    }
                    catch (SchedulerException e) {
                        logger.error("\u83b7\u53d6\u8c03\u5ea6\u5668\u5931\u8d25:", (Throwable)e);
                    }
                    continue;
                }
                if (hasExecClass.contains(key)) continue;
                try {
                    Object object = SpringUtils.getBeanById(key);
                    JobDetail jobDetail = JobBuilder.newJob(object.getClass()).withIdentity(this.getJobName(key), this.getJobGroupName(key)).build();
                    TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                    triggerBuilder.withIdentity(this.getTriggerName(key), this.getTriggerGroupName(key));
                    triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)scheduleClass.scheduleCycle()));
                    triggerBuilder.startNow();
                    SimpleTrigger trigger = (SimpleTrigger)triggerBuilder.build();
                    this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                    this.scheduler.start();
                    hasExecClass.add(key);
                    logger.info("\u5f00\u542f\u4e00\u4e2a\u65b0\u4efb\u52a1:" + key);
                }
                catch (SchedulerException e) {
                    logger.error("\u83b7\u53d6\u8c03\u5ea6\u5668\u5931\u8d25:", (Throwable)e);
                }
            }
        }
    }

    private String getTriggerName(String key) {
        return key + "_TriggerName";
    }

    private String getTriggerGroupName(String key) {
        return key + "_TriggerGroupName";
    }

    private String getJobName(String key) {
        return key + "_JobName";
    }

    private String getJobGroupName(String key) {
        return key + "_JobGroupName";
    }
}

