/*
 * Decompiled with CFR 0.152.
 */
package pams.function.common.push.service.impl;

import com.xdja.pushmanagerclient.start.Message;
import com.xdja.pushmanagerclient.start.PMClient;
import com.xdja.pushmanagerclient.start.Result;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.common.push.bean.XPushClient;
import pams.function.common.push.service.XPushService;
import pams.function.common.util.JsonUtils;

@Service
public class XPushServiceImpl
implements XPushService {
    private static Logger logger = LoggerFactory.getLogger(XPushServiceImpl.class);
    private static final int SUCCESS = 200;

    @Override
    public boolean push(List<String> pushIds, String jsonMsg, XPushClient client) throws Exception {
        return this.push(pushIds, jsonMsg, client, false);
    }

    @Override
    public boolean pushAsync(List<String> pushIds, String jsonMsg, XPushClient client) throws Exception {
        return this.push(pushIds, jsonMsg, client, true);
    }

    private boolean push(List<String> pushIds, String jsonMsg, XPushClient client, boolean isAsync) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a8\u90012.0\u6279\u91cf\u53d1\u9001\u901a\u77e5jsonMsg{},pushIds{}", (Object)jsonMsg, pushIds);
        }
        long reqId = System.currentTimeMillis() * 100000L + (long)new Random().nextInt(100000);
        HashSet<String> dstUsers = new HashSet<String>();
        for (String pushId : pushIds) {
            dstUsers.add(String.format(client.getDstUserIdFormat(), pushId));
        }
        ArrayList detList = new ArrayList(dstUsers);
        Message message = new Message(new Message.Builder().con(jsonMsg).exp(10000000L).sid(client.getCaller()).st(System.currentTimeMillis()));
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a8\u90012.0\u540c\u6b65\u6279\u91cf\u53d1\u9001\u901a\u77e5\u5185\u5bb9\u4e3a;{}", (Object)JsonUtils.toJsonStr(message));
        }
        ArrayList<String> devTypes = new ArrayList<String>();
        devTypes.add("ad");
        int resultCode = 0;
        if (isAsync) {
            Result result = client.getPmClient().asyncSendMsgByUser(reqId, client.getCaller(), client.getAppId(), message, dstUsers, client.getSendMode(), devTypes, "");
            if (logger.isDebugEnabled()) {
                logger.debug("\u63a8\u90012.0\u540c\u6b65\u6279\u91cf\u53d1\u9001\u901a\u77e5\u7ed3\u679c\u4e3a:{}", (Object)JsonUtils.toJsonStr(result));
            }
            if (result != null) {
                resultCode = result.getErrcode();
            }
        } else {
            Result result = client.getPmClient().sendMsgByUser(reqId, client.getCaller(), client.getAppId(), message, detList, client.getSendMode(), devTypes, "");
            if (logger.isDebugEnabled()) {
                logger.debug("\u63a8\u90012.0\u540c\u6b65\u6279\u91cf\u53d1\u9001\u901a\u77e5\u7ed3\u679c\u4e3a:{}", (Object)JsonUtils.toJsonStr(result));
            }
            if (result != null) {
                resultCode = result.getErrcode();
            }
        }
        if (resultCode == 200) {
            return true;
        }
        logger.error("\u63a8\u90012.0\u540c\u6b65\u6279\u91cf\u53d1\u9001\u901a\u77e5\u7ed3\u679c\u5931\u8d25:{}", (Object)JsonUtils.toJsonStr(resultCode));
        return false;
    }

    @Override
    public XPushClient init(String host, int port, String caller, String appId, int sendModel) throws Exception {
        XPushClient client = null;
        PMClient pmClient = new PMClient(host, port);
        long initReqId = System.currentTimeMillis() * 100000L + (long)new Random().nextInt(100000);
        boolean init = pmClient.init(initReqId);
        if (init) {
            if (!"echo".equals(this.echo(pmClient, caller))) {
                throw new Exception("\u521d\u59cb\u5316\u63a8\u9001\u5ba2\u6237\u7aef\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u76ee\u6216\u8005\u7f51\u7edc\u73af\u5883");
            }
        } else {
            logger.error("\u521d\u59cb\u5316\u63a8\u9001\u5ba2\u6237\u7aef\u5931\u8d25");
            throw new Exception("\u521d\u59cb\u5316\u63a8\u9001\u5ba2\u6237\u7aef\u5931\u8d25");
        }
        client = new XPushClient();
        client.setAppId(appId);
        client.setCaller(caller);
        client.setInitReqId(initReqId);
        client.setSendMode(sendModel);
        client.setDstUserIdFormat(appId + "/%s/pamsxpush");
        client.setPmClient(pmClient);
        logger.info("\u521d\u59cb\u5316\u63a8\u9001\u5ba2\u6237\u7aef\u6210\u529f");
        return client;
    }

    @Override
    public String echo(PMClient pmClient, String caller) throws Exception {
        return pmClient.echo(-1L, caller, "echo", null);
    }

    @Override
    public void shutDown(XPushClient client) throws Exception {
        if (client != null && client.getPmClient() != null) {
            logger.warn("\u5f00\u59cb\u5173\u95ed\u63a8\u9001......");
            client.getPmClient().shutDown(client.getInitReqId());
            logger.warn("\u5173\u95ed\u63a8\u9001\u7ed3\u675f");
        }
    }
}

