/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.service.impl;

import com.xdja.pams.bims.bean.PersonTmpBean;
import com.xdja.pams.bims.dao.PersonTmpDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonTmp;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.PersonTmpService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonTmpServiceImpl
implements PersonTmpService {
    @Autowired
    private PersonTmpDao dao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SysRoleService sysRoleService;

    @Override
    @Transactional
    public void save(PersonTmp entity) {
        String[] mobiles;
        List<PersonTmp> existinfo = this.dao.getByCode(entity.getCode());
        if (!existinfo.isEmpty()) {
            throw new RuntimeException("\u9884\u5f55\u5165\u8b66\u5458\u8b66\u53f7\u5df2\u5b58\u5728");
        }
        boolean existcode = this.userManageService.checkCode(entity.getCode());
        if (existcode) {
            throw new RuntimeException("\u8b66\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
        }
        boolean checkIdentifer = this.userManageService.checkIdentifer(entity.getIdentifier());
        if (checkIdentifer) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
        }
        existinfo = this.dao.getByIdentifier(entity.getIdentifier());
        if (!existinfo.isEmpty()) {
            throw new RuntimeException("\u9884\u5f55\u5165\u8b66\u5458\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728");
        }
        for (String mobileStr : mobiles = entity.getMobile().split(",")) {
            existinfo = this.dao.getByMobile(mobileStr);
            if (existinfo.isEmpty()) continue;
            throw new RuntimeException("\u9884\u5f55\u5165\u8b66\u5458\u624b\u673a\u53f7[" + mobileStr + "]\u5df2\u5b58\u5728");
        }
        String checkMobileIsExist = this.userManageService.checkMobileIsExist(mobiles);
        if (checkMobileIsExist != null) {
            throw new RuntimeException("\u624b\u673a\u53f7[" + checkMobileIsExist + "]\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
        }
        entity.setApprovalState("0");
        this.dao.save(entity);
    }

    @Override
    @Transactional
    public void update(PersonTmp editBean) {
        String[] mobiles;
        PersonTmp personTmp = this.dao.getById(editBean.getId());
        if ("1".equals(personTmp.getApprovalState())) {
            throw new RuntimeException("\u4e0d\u80fd\u4fee\u6539\u5df2\u5ba1\u6279\u7684\u8b66\u5458\u4fe1\u606f");
        }
        if (!editBean.getCreatorId().equals(personTmp.getCreatorId())) {
            throw new RuntimeException("\u4e0d\u80fd\u4fee\u6539\u5176\u4ed6\u7528\u6237\u63d0\u4ea4\u8b66\u5458\u4fe1\u606f");
        }
        boolean checkTmpInfo = this.dao.checkCode(editBean.getCode(), editBean.getId());
        if (checkTmpInfo) {
            throw new RuntimeException("\u9884\u5f55\u5165\u8b66\u5458\u8b66\u53f7\u5df2\u5b58\u5728");
        }
        boolean existcode = this.userManageService.checkCode(editBean.getCode());
        if (existcode) {
            throw new RuntimeException("\u8b66\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
        }
        boolean checkIdentifer = this.userManageService.checkIdentifer(editBean.getIdentifier());
        if (checkIdentifer) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
        }
        checkTmpInfo = this.dao.checkIdentifier(editBean.getIdentifier(), editBean.getId());
        if (checkTmpInfo) {
            throw new RuntimeException("\u9884\u5f55\u5165\u8b66\u5458\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728");
        }
        for (String mobileStr : mobiles = editBean.getMobile().split(",")) {
            checkTmpInfo = this.dao.checkMobile(mobileStr, editBean.getId());
            if (!checkTmpInfo) continue;
            throw new RuntimeException("\u9884\u5f55\u5165\u8b66\u5458\u624b\u673a\u53f7[" + mobileStr + "]\u5df2\u5b58\u5728");
        }
        String checkMobileIsExist = this.userManageService.checkMobileIsExist(mobiles);
        if (checkMobileIsExist != null) {
            throw new RuntimeException("\u624b\u673a\u53f7[" + checkMobileIsExist + "]\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
        }
        personTmp.setCode(editBean.getCode());
        personTmp.setName(editBean.getName());
        personTmp.setSex(editBean.getSex());
        personTmp.setPersonType(editBean.getPersonType());
        personTmp.setPolice(editBean.getPolice());
        personTmp.setPosition(personTmp.getPosition());
        personTmp.setIdentifier(editBean.getIdentifier());
        personTmp.setMobile(editBean.getMobile());
        personTmp.setDepId(editBean.getDepId());
        personTmp.setOfficePhone(editBean.getOfficePhone());
        personTmp.setOrderField(editBean.getOrderField());
        personTmp.setApprovalState("0");
        personTmp.setFilePath1(editBean.getFilePath1());
        personTmp.setOpinion("");
        this.dao.update(personTmp);
    }

    @Override
    @Transactional
    public void delete(String id) {
        this.dao.delete(id);
    }

    @Override
    public PersonTmp getById(String id) {
        return this.dao.getById(id);
    }

    @Override
    public List<PersonTmp> queryList(PersonTmpBean bean, Page page) {
        return this.dao.queryList(bean, page);
    }

    @Override
    public List<PersonTmpBean> queryBeanList(PersonTmpBean bean, Page page) {
        ArrayList<PersonTmpBean> beanList = new ArrayList<PersonTmpBean>();
        List<PersonTmp> list = this.queryList(bean, page);
        for (PersonTmp personTmp : list) {
            PersonTmpBean personTmpBean = new PersonTmpBean();
            BeanUtils.copyProperties((Object)personTmp, (Object)personTmpBean);
            Department dep = this.depManageService.queryDepById(personTmp.getDepId());
            personTmpBean.setDepName(dep.getName());
            personTmpBean.setSexName(this.commonCodeService.getCodeNameByCode(personTmp.getSex(), "sex"));
            personTmpBean.setPoliceName(this.commonCodeService.getCodeNameByCode(personTmp.getPolice(), "2012"));
            personTmpBean.setPositionName(this.commonCodeService.getCodeNameByCode(personTmp.getPosition(), "2011"));
            personTmpBean.setPersonTypeName(this.commonCodeService.getCodeNameByCode(personTmp.getPersonType(), "PERSON_TYPE"));
            Person createor = this.userManageService.queryPersonById(personTmp.getCreatorId());
            personTmpBean.setCreatorName(createor.getName());
            beanList.add(personTmpBean);
        }
        return beanList;
    }

    @Override
    @Transactional
    public ReturnResult approve(PersonTmp approveInfo) {
        ReturnResult rtnResult = new ReturnResult();
        PersonTmp personTmp = this.dao.getById(approveInfo.getId());
        if (!"0".equals(personTmp.getApprovalState())) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u5ba1\u6279\u72b6\u6001\u9519\u8bef\uff0c\u4e0d\u80fd\u5ba1\u6279");
            return rtnResult;
        }
        if ("2".equals(approveInfo.getApprovalState())) {
            personTmp.setApprovalState(approveInfo.getApprovalState());
            personTmp.setOpinion(approveInfo.getOpinion());
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
            return rtnResult;
        }
        boolean existcode = this.userManageService.checkCode(personTmp.getCode());
        if (existcode) {
            personTmp.setApprovalState("2");
            personTmp.setOpinion("\u8b66\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
            this.dao.update(personTmp);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u8b66\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528\uff0c\u5df2\u9000\u56de");
            return rtnResult;
        }
        boolean checkIdentifer = this.userManageService.checkIdentifer(personTmp.getIdentifier());
        if (checkIdentifer) {
            personTmp.setApprovalState("2");
            personTmp.setOpinion("\u8eab\u4efd\u8bc1\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
            this.dao.update(personTmp);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u8eab\u4efd\u8bc1\u53f7\u5df2\u6709\u8b66\u5458\u4f7f\u7528\uff0c\u5df2\u9000\u56de");
            return rtnResult;
        }
        String[] mobiles = personTmp.getMobile().split(",");
        String checkMobileIsExist = this.userManageService.checkMobileIsExist(mobiles);
        if (checkMobileIsExist != null) {
            personTmp.setApprovalState("2");
            personTmp.setOpinion("\u624b\u673a\u53f7[" + checkMobileIsExist + "]\u5df2\u6709\u8b66\u5458\u4f7f\u7528");
            this.dao.update(personTmp);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg("\u624b\u673a\u53f7[" + checkMobileIsExist + "]\u5df2\u6709\u8b66\u5458\u4f7f\u7528\uff0c\u5df2\u9000\u56de");
            return rtnResult;
        }
        Person person = new Person();
        person.setName(personTmp.getName());
        person.setCode(personTmp.getCode());
        person.setIdentifier(personTmp.getIdentifier());
        person.setSex(personTmp.getSex());
        person.setPosition(personTmp.getPosition());
        person.setPolice(personTmp.getPolice());
        person.setOfficePhone(personTmp.getOfficePhone());
        person.setMobileMultimediaMessage(personTmp.getMobileMultimediaMessage());
        person.setMobilePersonal(personTmp.getMobilePersonal());
        ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        if (personTmp.getMobile() != null) {
            for (String strMobile : mobiles) {
                Mobile mobile = new Mobile();
                mobile.setMobile(strMobile);
                mobileList.add(mobile);
            }
            person.setMobiledList(mobileList);
        }
        person.setMobile(personTmp.getMobile());
        person.setOrderField(personTmp.getOrderField());
        person.setDepartment(this.depManageService.queryDepById(personTmp.getDepId()));
        person.setPersonType(personTmp.getPersonType());
        person.setDepCode(person.getDepartment().getCode());
        ArrayList<Role> roleList = new ArrayList<Role>();
        String isSetSysRole = this.systemConfigService.getValueByCode("isSetSysRole");
        if ("0".equals(isSetSysRole)) {
            roleList.addAll(this.sysRoleService.queryDefaultRoleList());
        }
        person.setRoleList(roleList);
        person.setCreatorId(personTmp.getCreatorId());
        person.setLastChangePwDate(new Date());
        this.userManageService.addUser(person);
        personTmp.setApprovalState("1");
        this.dao.update(personTmp);
        rtnResult.setRtnCode("0");
        rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
        return rtnResult;
    }

    @Override
    public PersonTmpBean getBeanById(String id) {
        PersonTmp personTmp = this.getById(id);
        PersonTmpBean personTmpBean = new PersonTmpBean();
        BeanUtils.copyProperties((Object)personTmp, (Object)personTmpBean);
        Department dep = this.depManageService.queryDepById(personTmp.getDepId());
        personTmpBean.setDepName(dep.getName());
        personTmpBean.setSexName(this.commonCodeService.getCodeNameByCode(personTmp.getSex(), "sex"));
        personTmpBean.setPoliceName(this.commonCodeService.getCodeNameByCode(personTmp.getPolice(), "2012"));
        personTmpBean.setPositionName(this.commonCodeService.getCodeNameByCode(personTmp.getPosition(), "2011"));
        personTmpBean.setPersonTypeName(this.commonCodeService.getCodeNameByCode(personTmp.getPersonType(), "PERSON_TYPE"));
        Person createor = this.userManageService.queryPersonById(personTmp.getCreatorId());
        personTmpBean.setCreatorName(createor.getName());
        return personTmpBean;
    }
}

