/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.filter;

import com.xdja.pams.common.filter.RolePowerFilters;
import com.xdja.pams.common.filter.SafeFilters;
import com.xdja.pams.common.util.MD5Util;
import com.xdja.pams.common.util.Util;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectFilter
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = 5286703103846683570L;
    private static final Logger log = LoggerFactory.getLogger(RolePowerFilters.class);
    private static String sqlReg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|alter|drop|execute|having)\\b)";
    private static String jsReg = "(script|src[\r\n]*=[\r\n]*(.*?)|eval\\((.*?)\\)|iframe|e\u00adxpression\\((.*?)\\)|javascript:|vbscript:|onload(.*?)=|WEB-INF|web(.*?).xml|\\.\\.|Content-Type|alert(.*?)|onclick|ondblclick|onerror|onkeydown|onload|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup|onresize|onselect|onsubmit|onunload|onfocus|input|onblur|onchange|onabort|onkeypress|onkeyup|<|>)";
    private static Pattern sqlPattern = Pattern.compile(sqlReg, 2);
    private static Pattern jsPattern = Pattern.compile(jsReg, 2);

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterchain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = req.getRequestURI();
        String result = this.injectInput((ServletRequest)req);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            log.warn("\u53c2\u6570\u542b\u6709\u6ce8\u5165\u653b\u51fb\u975e\u6cd5\u5b57\u7b26\uff1a" + result);
            String ajaxSubmit = req.getHeader("X-Requested-With");
            if (ajaxSubmit != null && ajaxSubmit.equals("XMLHttpRequest")) {
                if (request.getParameter("rtnDataType") != null && "page".equals(request.getParameter("rtnDataType"))) {
                    httpResponse.sendRedirect(req.getContextPath() + "/view/error/error.html");
                    return;
                }
                httpResponse.setStatus(400);
                httpResponse.addHeader("Inject-param", "Inject-param");
                return;
            }
            httpResponse.sendRedirect(req.getContextPath() + "/view/error/error.html");
            return;
        }
        for (int i = 0; i < SafeFilters.fireURLList.length; ++i) {
            if (!url.contains(SafeFilters.fireURLList[i])) continue;
            filterchain.doFilter(request, response);
            return;
        }
        if (this.checkQueryParameterComplete((HttpServletRequest)request)) {
            filterchain.doFilter(request, response);
            return;
        }
        if (request.getParameter("rtnDataType") != null && "page".equals(request.getParameter("rtnDataType"))) {
            httpResponse.sendRedirect(req.getContextPath() + "/view/error/dataModification.html");
            return;
        }
        httpResponse.setStatus(400);
        httpResponse.addHeader("data-falsified", "data be falsified");
    }

    public boolean checkQueryParameterComplete(HttpServletRequest request) {
        if (request.getHeader("x-requested-with") == null || !request.getHeader("x-requested-with").equalsIgnoreCase("XMLHttpRequest")) {
            return true;
        }
        try {
            String[] paramArray = this.getUrlParam(this.comboneRequestParameter(request).split("&"));
            StringBuilder parameterString = new StringBuilder();
            for (String str : paramArray) {
                parameterString.append(str).append("&");
            }
            parameterString = new StringBuilder(parameterString.substring(0, parameterString.length() - 1));
            String entryHeaderString = request.getHeader("request-integrity");
            String entryParam = URLEncoder.encode(parameterString.toString(), "UTF-8").replace("+", "%2B");
            log.debug(entryParam);
            return MD5Util.encoderByPrueMd5(entryParam).equals(entryHeaderString);
        }
        catch (Exception e2) {
            log.error(e2.getMessage() + "\u8bf7\u6c42\u53c2\u6570\u5b8c\u6574\u6027\u6821\u9a8c\u5931\u8d25", (Throwable)e2);
            return false;
        }
    }

    private String[] getUrlParam(String[] keys) {
        for (int i = 0; i < keys.length - 1; ++i) {
            for (int j = 0; j < keys.length - i - 1; ++j) {
                String pre = keys[j];
                String next = keys[j + 1];
                if (!this.isMoreThan(pre, next)) continue;
                keys[j] = next;
                keys[j + 1] = pre;
            }
        }
        return keys;
    }

    private boolean isMoreThan(String pre, String next) {
        if (null == pre || null == next || "".equals(pre) || "".equals(next)) {
            return false;
        }
        char[] c_pre = pre.toCharArray();
        char[] c_next = next.toCharArray();
        int minSize = Math.min(c_pre.length, c_next.length);
        for (int i = 0; i < minSize; ++i) {
            if (c_pre[i] > c_next[i]) {
                return true;
            }
            if (c_pre[i] >= c_next[i]) continue;
            return false;
        }
        return c_pre.length > c_next.length;
    }

    public String comboneRequestParameter(HttpServletRequest request) {
        Map map = request.getParameterMap();
        StringBuilder resultString = new StringBuilder();
        int index = 0;
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = o;
            if ("_".equals(entry.getKey())) continue;
            for (int i = 0; i < ((Object[])entry.getValue()).length; ++i) {
                if (index == 0) {
                    ++index;
                } else {
                    resultString.append("&");
                }
                resultString.append((String)entry.getKey() + "=" + ((String[])entry.getValue())[i]);
            }
        }
        return resultString.toString();
    }

    private String injectInput(ServletRequest request) {
        Enumeration e2 = request.getParameterNames();
        while (e2.hasMoreElements()) {
            String[] attributeValues;
            String attributeName = (String)e2.nextElement();
            if ("password".equals(attributeName)) continue;
            for (String attributeValue : attributeValues = request.getParameterValues(attributeName)) {
                if (StringUtils.isBlank((CharSequence)attributeValue)) continue;
                if (!InjectFilter.jsValidate(attributeValue)) {
                    return attributeValue;
                }
                if (InjectFilter.sqlValidate(attributeValue)) continue;
                return attributeValue;
            }
        }
        return "";
    }

    private static boolean sqlValidate(String str) {
        if (sqlPattern.matcher(str).find()) {
            log.warn("\u672a\u901a\u8fc7sql\u6ce8\u5165\u6821\u9a8c\uff1a" + str);
            return false;
        }
        return true;
    }

    private static boolean jsValidate(String str) {
        if (jsPattern.matcher(str).find()) {
            log.warn("\u672a\u901a\u8fc7js\u6ce8\u5165\u6821\u9a8c\uff1a" + str);
            return false;
        }
        return true;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        if (SafeFilters.fireURLList == null) {
            Util util = new Util();
            SafeFilters.fireURLList = util.getProFile("common.filter.fireURL");
        }
    }
}

