/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.resource;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceBundleMessageSource
extends org.springframework.context.support.ResourceBundleMessageSource {
    private String[] basenameLocaleArr = new String[]{"zh_CN", "en_US"};
    private final Map<String, Map<Locale, ResourceBundle>> cachedResourceBundles = new HashMap<String, Map<Locale, ResourceBundle>>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        Map<String, Map<Locale, ResourceBundle>> map = this.cachedResourceBundles;
        synchronized (map) {
            ResourceBundle bundle;
            Map<Locale, ResourceBundle> localeMap = this.cachedResourceBundles.get(basename);
            if (localeMap != null && (bundle = localeMap.get(locale)) != null) {
                return bundle;
            }
            try {
                bundle = this.doGetBundle(basename, locale);
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage()));
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, Map<Locale, ResourceBundle>> map = this.cachedResourceBundles;
        synchronized (map) {
            this.cachedResourceBundles.clear();
            ResourceBundle.clearCache(this.getBundleClassLoader());
        }
    }

    public void setBasenameLocales(String basenameLocales) {
        if (basenameLocales != null) {
            this.basenameLocaleArr = basenameLocales.split(",");
        }
    }

    public void setBasenamePrefix(String basenamePrefix) {
        if (basenamePrefix != null) {
            try {
                String parent = "/";
                String pattern = basenamePrefix.substring(0, basenamePrefix.length() - 1);
                if (basenamePrefix.lastIndexOf("/") > 0) {
                    parent = basenamePrefix.substring(0, basenamePrefix.lastIndexOf("/"));
                    pattern = basenamePrefix.substring(basenamePrefix.lastIndexOf("/") - 1);
                }
                ArrayList<String> basenameList = new ArrayList<String>();
                URL resource = Thread.currentThread().getContextClassLoader().getResource("");
                File file = new File(resource.toURI());
                File[] files = file.listFiles();
                if (files != null && files.length > 0) {
                    for (int i = 0; i < files.length; ++i) {
                        String name;
                        String basename;
                        if (!files[i].getName().startsWith(pattern) || (basename = this.formatBasenameByPrefix(basenamePrefix, name = files[i].getName())) == null || basenameList.contains(basename)) continue;
                        basenameList.add(basename);
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Based on basenamePrefix[" + basenamePrefix + "], get all basenames: " + basenameList));
                }
                String[] basenames = new String[basenameList.size()];
                this.setBasenames(basenameList.toArray(basenames));
            }
            catch (Exception e2) {
                this.logger.error((Object)"setBasenamePattern error", (Throwable)e2);
            }
        }
    }

    private String formatBasenameByPrefix(String basenamePrefix, String checkedName) {
        String basename = null;
        Pattern pattern = Pattern.compile("^(" + basenamePrefix + ")(.*)\\.properties$");
        Matcher matcher = pattern.matcher(checkedName);
        if (matcher.find()) {
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (group2.startsWith("_")) {
                for (String locale : this.basenameLocaleArr) {
                    if (group2.endsWith(locale)) {
                        int i = group2.lastIndexOf(locale);
                        if (i == 1) {
                            basename = group1;
                        } else if (i > 1) {
                            basename = group1 + group2.substring(0, group2.lastIndexOf(locale) - 1);
                        }
                        if (basename == null) continue;
                        break;
                    }
                    basename = group1 + group2;
                }
            }
            if (basename == null) {
                basename = group1;
            }
        }
        return basename;
    }
}

