/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public String[] scopeVersion(String fileUrl, String vFrom, String vTo) {
        String[] rtnStrs = null;
        ArrayList<String> rtnList = null;
        if (vFrom.compareTo(vTo) >= 0) {
            log.error("\u5f00\u59cb\u7248\u672c\u4e0d\u80fd\u5927\u4e8e\u76ee\u6807\u7248\u672c");
            return rtnStrs;
        }
        File file = new File(fileUrl);
        if (file.exists() && file.isDirectory()) {
            rtnList = new ArrayList<String>();
            File[] fs = file.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].isDirectory()) continue;
                String tmpName = "";
                try {
                    tmpName = fs[i].getName().split("-")[1];
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    continue;
                }
                if (vFrom.compareTo(tmpName) > 0 || vTo.compareTo(tmpName) < 0) continue;
                rtnList.add(fs[i].getName());
            }
            if (!rtnList.isEmpty()) {
                rtnStrs = new String[rtnList.size()];
                rtnList.toArray(rtnStrs);
                this.sort(rtnStrs);
            }
        }
        return rtnStrs;
    }

    private void sort(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length - i - 1; ++j) {
                String b;
                String a = values[j].split("-")[1];
                if (a.compareTo(b = values[j + 1].split("-")[1]) <= 0) continue;
                String temp = values[j];
                values[j] = values[j + 1];
                values[j + 1] = temp;
            }
        }
    }

    public static boolean copyFile(String file1, String file2, String fileName) throws IOException {
        File in = new File(file1);
        File out = new File(file2);
        if (!in.exists()) {
            log.error(in.getAbsolutePath() + "\u6e90\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01\uff01\uff01");
            return false;
        }
        if (!in.isFile()) {
            log.error("\u53ea\u80fd\u590d\u5236\u5355\u4e2a\u6587\u4ef6");
            return false;
        }
        if (!out.exists()) {
            out.mkdirs();
        }
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(in);
        }
        catch (FileNotFoundException e2) {
            try {
                fin.close();
            }
            catch (IOException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
            log.error(e2.getMessage(), (Throwable)e2);
            throw e2;
        }
        try {
            fout = new FileOutputStream(new File(file2 + fileName));
        }
        catch (FileNotFoundException e3) {
            try {
                fout.close();
            }
            catch (IOException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
            log.error(e3.getMessage(), (Throwable)e3);
            throw e3;
        }
        byte[] b = new byte[1024];
        try {
            int y = -1;
            while ((y = fin.read(b)) != -1) {
                fout.write(b, 0, y);
            }
            fin.close();
            fout.flush();
            fout.close();
        }
        catch (IOException e4) {
            try {
                fin.close();
                fout.close();
            }
            catch (IOException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
            log.error(e4.getMessage(), (Throwable)e4);
            throw e4;
        }
        fin.close();
        fout.close();
        return true;
    }

    public static boolean copy(String file1, String file2) {
        File in = new File(file1);
        File out = new File(file2);
        if (!in.exists()) {
            log.error(in.getAbsolutePath() + "\u6e90\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01\uff01\uff01");
            return false;
        }
        if (!out.exists()) {
            out.mkdirs();
        }
        File[] file = in.listFiles();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                try {
                    fin = new FileInputStream(file[i]);
                }
                catch (FileNotFoundException e2) {
                    try {
                        fin.close();
                    }
                    catch (IOException e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    log.error(e2.getMessage(), (Throwable)e2);
                    return false;
                }
                try {
                    fout = new FileOutputStream(new File(file2 + "\\" + file[i].getName()));
                }
                catch (FileNotFoundException e3) {
                    try {
                        fout.close();
                    }
                    catch (IOException e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    log.error(e3.getMessage(), (Throwable)e3);
                    return false;
                }
                byte[] b = new byte[1024];
                try {
                    int y = -1;
                    while ((y = fin.read(b)) != -1) {
                        fout.write(b, 0, y);
                    }
                    fin.close();
                    fout.flush();
                    fout.close();
                }
                catch (IOException e4) {
                    try {
                        fin.close();
                        fout.close();
                    }
                    catch (IOException e1) {
                        log.error(e4.getMessage(), (Throwable)e1);
                    }
                    log.error(e4.getMessage(), (Throwable)e4);
                }
                continue;
            }
            FileUtil.copy(file1 + "\\" + file[i].getName(), file2 + "\\" + file[i].getName());
        }
        return true;
    }

    public static long getFileSizes(File f) throws Exception {
        long s = 0L;
        if (f.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(f);
            s = fis.available();
            fis.close();
        } else {
            f.createNewFile();
        }
        return s;
    }

    public static long getFileSize(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileUtil.getFileSize(flist[i]);
                continue;
            }
            size += flist[i].length();
        }
        return size;
    }

    public static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static String FormetFileSizeToM(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format((double)fileS / 1048576.0) + "M";
    }

    public static long FormetFileSizeToMLong(long fileS) {
        return fileS / 0x100000L;
    }

    public static void deleteFile(File f) {
        boolean rtn = false;
        if (f != null && f.exists()) {
            if (f.isFile()) {
                rtn = f.delete();
                if (rtn) {
                    log.info("\u5220\u9664\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\u3010" + f.getAbsolutePath() + "\u3011");
                } else {
                    log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u3010" + f.getAbsolutePath() + "\u3011");
                }
            } else {
                for (File f1 : f.listFiles()) {
                    FileUtil.deleteFile(f1);
                }
                if (f.delete()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\u3010" + f.getAbsolutePath() + "\u3011");
                } else {
                    log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u3010" + f.getAbsolutePath() + "\u3011");
                }
            }
        }
    }
}

