/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import java.util.HashSet;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinYin4j {
    private static final Logger log = LoggerFactory.getLogger(PinYin4j.class);
    public static final String Separator = "#";

    public static String getNameSimplicity(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] _t = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (_t == null) continue;
                    pybf.append(_t[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String getNamePinyin(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] _t = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (_t == null) continue;
                    pybf.append(_t[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String getNameSimplicityWithPolyphone(String chinese) {
        String[][] pinyinArr = PinYin4j.getSimplicity(PinYin4j.getPinyin(chinese));
        if (pinyinArr == null) {
            return null;
        }
        String[][] rtnArr = PinYin4j.doAssemble(pinyinArr);
        StringBuffer sb = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        for (String str : rtnArr[0]) {
            set.add(str);
        }
        for (String str : set) {
            sb.append(str).append(Separator);
        }
        String rtnStr = sb.toString();
        if (rtnStr.length() > 0) {
            rtnStr = rtnStr.substring(0, rtnStr.length() - Separator.length());
        }
        return rtnStr;
    }

    public static String getNamePinyinWithPolyphone(String chinese) {
        String[][] pinyinArr = PinYin4j.getPinyin(chinese);
        if (pinyinArr == null) {
            return null;
        }
        String[][] rtnArr = PinYin4j.doAssemble(pinyinArr);
        StringBuffer sb = new StringBuffer();
        for (String str : rtnArr[0]) {
            sb.append(str).append(Separator);
        }
        String rtnStr = sb.toString();
        if (rtnStr.length() > 0) {
            rtnStr = rtnStr.substring(0, rtnStr.length() - Separator.length());
        }
        return rtnStr;
    }

    private static String[][] getSimplicity(String[][] pinyinArr) {
        for (int i = 0; i < pinyinArr.length; ++i) {
            for (int j = 0; j < pinyinArr[i].length; ++j) {
                if (pinyinArr[i][j] == null || pinyinArr[i][j].length() <= 0) continue;
                pinyinArr[i][j] = pinyinArr[i][j].substring(0, 1);
            }
        }
        return pinyinArr;
    }

    private static String[][] doAssemble(String[][] pinyinArr) {
        int len = pinyinArr.length;
        if (len >= 2) {
            int len1 = pinyinArr[0].length;
            int len2 = pinyinArr[1].length;
            int newLen = len1 * len2;
            String[] temp = new String[newLen];
            int index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[index] = pinyinArr[0][i] + pinyinArr[1][j];
                    ++index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = pinyinArr[i];
            }
            newArray[0] = temp;
            return PinYin4j.doAssemble(newArray);
        }
        return pinyinArr;
    }

    private static String[][] getPinyin(String chinese) {
        if (chinese != null && !chinese.trim().equals("")) {
            char[] srcChar = chinese.toCharArray();
            String[][] temp = new String[chinese.length()][];
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            for (int i = 0; i < srcChar.length; ++i) {
                char charTemp = srcChar[i];
                if (String.valueOf(charTemp).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)charTemp, (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                        if (temp[i] != null) continue;
                        temp[i] = new String[]{""};
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e2) {
                        log.error(e2.getMessage(), (Throwable)e2);
                    }
                    continue;
                }
                temp[i] = charTemp >= 'A' && charTemp <= 'Z' || charTemp >= 'a' && charTemp <= 'z' ? new String[]{String.valueOf(srcChar[i])} : new String[]{""};
            }
            return temp;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(PinYin4j.getNameSimplicityWithPolyphone("\u674e\u6730"));
        System.out.println(PinYin4j.getNameSimplicity("\u91cd  \u5e86"));
        System.out.println(PinYin4j.getNamePinyin("\u91cd \u5e86"));
        System.out.println(PinYin4j.getNamePinyinWithPolyphone("\u91cd\u5e86\u5355\u7530 \u82b3"));
        System.out.println(PinYin4j.getNameSimplicityWithPolyphone("\u91cd\u5e86\u5355\u7530 \u82b3"));
        System.out.println(PinYin4j.getNamePinyinWithPolyphone("\u738b\u4e8c\u9ebb \u5b50"));
    }
}

