/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.fjjg.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.fjjg.bean.BklxBean;
import com.xdja.pams.fjjg.dao.BklxDao;
import com.xdja.pams.fjjg.entity.Bklx;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class BklxDaoImpl
implements BklxDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<Bklx> query(BklxBean queryBean) {
        StringBuilder selectSql = new StringBuilder("select * from t_bklx_jh where 1=1 ");
        ArrayList<String> param = new ArrayList<String>();
        if (StringUtils.hasText((String)queryBean.getJh())) {
            selectSql.append("and jh=?");
            param.add(queryBean.getJh());
        }
        List<Map> list = this.baseDao.getListBySQL(selectSql.toString(), param.toArray(), Map.class);
        return this.cover2Bklx(list);
    }

    private List<Bklx> cover2Bklx(List<Map> list) {
        ArrayList<Bklx> result = new ArrayList<Bklx>();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        Bklx bklx = null;
        for (Map map : list) {
            bklx = new Bklx();
            bklx.setBhlx(map.get("BKLX") + "");
            bklx.setJh(map.get("JH") + "");
            result.add(bklx);
        }
        return result;
    }

    @Override
    public void add(Bklx bklx) {
        String insertSql = "insert into t_bklx_jh(bklx,jh) values(?,?)";
        ArrayList<String> param = new ArrayList<String>();
        param.add(bklx.getBhlx());
        param.add(bklx.getJh());
        this.baseDao.updateBySql(insertSql, param.toArray());
    }

    @Override
    public void remove(String jh) {
        String deleteSql = "delete from t_bklx_jh where jh=? ";
        this.baseDao.updateBySql(deleteSql, new String[]{jh});
    }
}

