/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.fjjg.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.fjjg.bean.BindApplyBean;
import com.xdja.pams.fjjg.bean.BindInfoBean;
import com.xdja.pams.fjjg.bean.FjjgPushBean;
import com.xdja.pams.fjjg.bean.PushBindBean;
import com.xdja.pams.fjjg.dao.BindApplyDao;
import com.xdja.pams.fjjg.dao.BindInfoDao;
import com.xdja.pams.fjjg.entity.BindApply;
import com.xdja.pams.fjjg.entity.BindInfo;
import com.xdja.pams.fjjg.service.BindApplyService;
import com.xdja.pams.fjjg.service.BklxService;
import com.xdja.pams.fjjg.service.FjjgPnPushService;
import com.xdja.pams.fjjg.service.KkbhService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BindApplyServiceImpl
implements BindApplyService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private BindInfoDao bindInfoDao;
    @Autowired
    private BindApplyDao bindApplyDao;
    @Autowired
    private BklxService bklxService;
    @Autowired
    private KkbhService kkbhService;
    @Autowired
    private FjjgPnPushService fjjgPnPushService;

    @Override
    public List<BindApplyBean> getList(BindApplyBean queryBean, String controlDepIds, String controlPolices, Page page) throws Exception {
        ArrayList<BindApplyBean> result = new ArrayList<BindApplyBean>();
        List<BindApply> list = this.bindApplyDao.queryNativeByPage(queryBean, controlDepIds, controlPolices, page);
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        BindApplyBean bean = null;
        Object module = null;
        for (BindApply bindApply : list) {
            bean = new BindApplyBean();
            BeanUtils.copyProperties((Object)bindApply, (Object)bean);
            Person fj = this.userManageService.queryPersonById(bean.getFjId());
            Person mj = this.userManageService.queryPersonById(bean.getMjId());
            bean.setMjName(mj.getName());
            bean.setMjDepName(mj.getDepartment().getName());
            bean.setFjName(fj.getName());
            bean.setFjDepName(fj.getDepartment().getName());
            bean.setFjCode(fj.getCode());
            bean.setFjMobile(fj.getMobile());
            bean.setApplyContent("\u7533\u8bf7\u7ed1\u5b9a");
            result.add(bean);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applyBind(String fjId) throws Exception {
        BindInfoBean bean = new BindInfoBean();
        bean.setFjId(fjId);
        List<BindInfo> list = this.bindInfoDao.query(bean, null);
        if (CollectionUtils.isEmpty(list)) {
            throw new Exception("\u672a\u5206\u6d3e\u7ba1\u8f96\u6c11\u8b66");
        }
        BindInfo bindInfo = list.get(0);
        BindApplyBean queryApplyBean = new BindApplyBean();
        queryApplyBean.setState("0");
        queryApplyBean.setFjId(fjId);
        List<BindApply> bindApplyList = this.bindApplyDao.query(queryApplyBean, null);
        if (!CollectionUtils.isEmpty(bindApplyList)) {
            throw new Exception("\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u7533\u8bf7\uff0c\u8bf7\u7b49\u5f85\u6c11\u8b66\u5ba1\u6279");
        }
        long currentTime = System.currentTimeMillis();
        BindApply apply = new BindApply();
        apply.setFjId(fjId);
        apply.setState("0");
        apply.setMjId(bindInfo.getMjId());
        apply.setCreateTime(currentTime);
        apply.setUpdateTime(currentTime);
        this.bindApplyDao.add(apply);
        bindInfo.setState("1");
        this.bindInfoDao.update(bindInfo);
        Person fj = this.userManageService.queryPersonById(bindInfo.getFjId());
        Person mj = this.userManageService.queryPersonById(bindInfo.getMjId());
        PushBindBean pushBindBean = new PushBindBean("", fj.getName(), mj.getName());
        FjjgPushBean pushBean = new FjjgPushBean("2", Util.toJsonStr(pushBindBean));
        this.fjjgPnPushService.push(bindInfo.getMjId(), pushBean);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doApplyBind(BindApplyBean bean) throws Exception {
        Person fj;
        BindApplyBean queryApplyBean = new BindApplyBean();
        queryApplyBean.setState("0");
        queryApplyBean.setFjId(bean.getFjId());
        List<BindApply> bindApplyList = this.bindApplyDao.query(queryApplyBean, null);
        if (CollectionUtils.isEmpty(bindApplyList) || bindApplyList.size() != 1) {
            throw new Exception("\u6570\u636e\u5f02\u5e38");
        }
        BindApply bindApply = bindApplyList.get(0);
        bindApply.setState(bean.getState());
        bindApply.setUpdateTime(System.currentTimeMillis());
        this.bindApplyDao.update(bindApply);
        BindInfoBean queryBindBean = new BindInfoBean();
        queryBindBean.setState("1");
        queryBindBean.setFjId(bean.getFjId());
        queryBindBean.setMjId(bindApply.getMjId());
        List<BindInfo> bindInfoList = this.bindInfoDao.query(queryBindBean, null);
        if (CollectionUtils.isEmpty(bindInfoList) && bindInfoList.size() != 1) {
            throw new Exception("\u6570\u636e\u5f02\u5e38");
        }
        BindInfo bindInfo = bindInfoList.get(0);
        if ("1".equals(bean.getState())) {
            bindInfo.setState("2");
            this.bklxService.init(bindInfo.getFjId(), bindInfo.getMjId());
            this.kkbhService.init(bindInfo.getFjId(), bindInfo.getMjId());
            fj = this.userManageService.queryPersonById(bean.getFjId());
        } else {
            bindInfo.setState("0");
        }
        this.bindInfoDao.update(bindInfo);
        fj = this.userManageService.queryPersonById(bindInfo.getFjId());
        Person mj = this.userManageService.queryPersonById(bindInfo.getMjId());
        PushBindBean pushBindBean = new PushBindBean(bean.getState(), fj.getName(), mj.getName());
        FjjgPushBean pushBean = new FjjgPushBean("0", Util.toJsonStr(pushBindBean));
        this.fjjgPnPushService.push(bindInfo.getFjId(), pushBean);
    }
}

