/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.logms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.bean.LogQueryConditionIn;
import com.xdja.pams.logms.bean.SysPowerBean;
import com.xdja.pams.logms.entity.UserOperateLog;
import com.xdja.pams.logms.service.LogmsService;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.upms.entity.SysPower;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SystemLogControler
extends BaseControler {
    @Autowired
    private LogmsService logmsService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemConfigPbService scps;
    private static final Logger log = LoggerFactory.getLogger(SystemLogControler.class);

    @RequestMapping(value={"/logms/systemLogControler/systemLogManager.do"})
    public String indexInit(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        ArrayList<SysPowerBean> sysPowerList = null;
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            SysPowerBean spb1 = new SysPowerBean();
            spb1.setCode("");
            spb1.setName(MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
            sysPowerList = new ArrayList<SysPowerBean>();
            sysPowerList.add(spb1);
            List<SysPower> sysPowerListTmp = this.operator.getTopFunctions();
            if (sysPowerListTmp != null) {
                for (SysPower sp : sysPowerListTmp) {
                    SysPowerBean spb = new SysPowerBean();
                    spb.setCode(sp.getId());
                    spb.setName(sp.getName());
                    spb.setCodeAndName(sp.getId() + "," + sp.getName());
                    sysPowerList.add(spb);
                }
            }
            SysPowerBean spb = new SysPowerBean();
            spb.setCode("SCMS0302");
            spb.setName("\u5b89\u5168\u5361\u7ba1\u7406-\u5199\u5361");
            spb.setCodeAndName("SCMS0302,\u5b89\u5168\u5361\u7ba1\u7406-\u5199\u5361");
            sysPowerList.add(spb);
            spb = new SysPowerBean();
            spb.setCode("SCMS0303");
            spb.setName("\u5b89\u5168\u5361\u7ba1\u7406-\u64a4\u5361");
            spb.setCodeAndName("SCMS0302,\u5b89\u5168\u5361\u7ba1\u7406-\u64a4\u5361");
            sysPowerList.add(spb);
            map.put((Object)"sysPowerList", (Object)Util.toJsonStr(sysPowerList));
            Date date = new Date();
            String fromDate = Util.getDate("yyyy-MM-dd", Util.relationMonth(date, -1));
            String ToDate = Util.getDate("yyyy-MM-dd", date);
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)ToDate);
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/logms/systemLogControler/getSystemLogList.do"})
    public void getSystemLogList(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map, LogQueryConditionIn loIn) {
        String jsonStr = "";
        try {
            String controlDeps = this.getControlDeps(request);
            controlDeps = controlDeps + "," + this.person.getDepId();
            loIn.setControlDepIds(controlDeps);
            Page p = new Page(page.getPage(), page.getRows());
            StringBuffer tmpOperateName = new StringBuffer();
            if (Util.varCheckEmp(loIn.getOperateName())) {
                List<SysPower> result = this.operator.getTopFunctions();
                for (SysPower sp : result) {
                    this.getOperateCodes(sp, tmpOperateName);
                }
                tmpOperateName.append("LOGIN");
                tmpOperateName.append(",SSO");
            } else {
                String[] opNames = loIn.getOperateName().split(",");
                Map<String, SysPower> topFunctions = this.operator.getTopMenu();
                for (String opName : opNames) {
                    SysPower sp = topFunctions.get(opName);
                    this.getOperateCodes(sp, tmpOperateName);
                }
                if (loIn.getOperateName().indexOf("SCMS0302") >= 0) {
                    tmpOperateName.append("SCMS0302");
                    tmpOperateName.append(",");
                }
                if (loIn.getOperateName().indexOf("SCMS0303") >= 0) {
                    tmpOperateName.append("SCMS0303");
                    tmpOperateName.append(",");
                }
            }
            loIn.setOperateName(tmpOperateName.toString());
            ArrayList rtnList = this.logmsService.getUserOperateLogList(loIn, p);
            HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
            rtnMap.put("total", Integer.valueOf(p.getTotal()));
            rtnMap.put("rows", rtnList == null ? new ArrayList() : rtnList);
            jsonStr = Util.toJsonStr(rtnMap);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
            jsonStr = "";
        }
        Util.writeUtf8Text(response, jsonStr);
    }

    @RequestMapping(value={"/logms/systemLogControler/importSystemLogsByExcel.do"})
    public void importSystemLogsByExcel(HttpServletRequest request, HttpServletResponse response, ModelMap map, LogQueryConditionIn loIn) {
        try {
            Page page = new Page(1, Integer.parseInt(this.scps.getValueByCode("maxExcelCount")));
            StringBuffer tmpOperateName = new StringBuffer();
            if (Util.varCheckEmp(loIn.getOperateName())) {
                List<SysPower> result = this.operator.getTopFunctions();
                for (SysPower sp : result) {
                    this.getOperateCodes(sp, tmpOperateName);
                }
                tmpOperateName.append("LOGIN");
            } else {
                String[] opNames = loIn.getOperateName().split(",");
                Map<String, SysPower> topFunctions = this.operator.getTopMenu();
                for (String opName : opNames) {
                    SysPower sp = topFunctions.get(opName);
                    this.getOperateCodes(sp, tmpOperateName);
                }
            }
            loIn.setOperateName(tmpOperateName.toString());
            List<UserOperateLog> rtnList = this.logmsService.getUserOperateLogList(loIn, page);
            String fileName = Util.toUtf8String(this.scps.getValueByCode("importSysLogsFileName")) + ".xls";
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("application/vnd.ms-excel");
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.userId"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.userName"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.orgCode"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.orgName"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.terminalId"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.errorCode"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.operateName"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.operateType"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.operateResult"));
            titleList.add(MessageManager.getProMessage(this.message, "logms.page.info.operateTime"));
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), this.scps.getValueByCode("importSysLogsTitle"), this.scps.getValueByCode("importSysLogsTitle"), rtnList, titleList);
        }
        catch (Exception e2) {
            log.error("\u5bfc\u51fa\u7cfb\u7edf\u65e5\u5fd7EXCEL\u51fa\u73b0\u5f02\u5e38", (Throwable)e2);
            Util.writeUtf8Text(response, MessageManager.getProMessage(this.message, "exp.error.msg"));
        }
    }

    private void getOperateCodes(SysPower sp, StringBuffer strBuff) {
        if (sp != null) {
            strBuff.append(sp.getId());
            strBuff.append(",");
            if (sp.getChildrenList() != null) {
                for (SysPower sp1 : sp.getChildrenList()) {
                    this.getOperateCodes(sp1, strBuff);
                }
            }
        }
    }
}

