/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.portals.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sso.bean.AppDetailQueryOutResultContent;
import com.xdja.pams.sso.bean.AppUsageQueryOutResult;
import com.xdja.pams.sso.service.AppPlatformService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.wzmh.bean.PageBean;
import com.xdja.pams.wzmh.bean.QueryWebPortalBean;
import com.xdja.pams.wzmh.entity.WebPortal;
import com.xdja.pams.wzmh.service.WebPortalService;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PortalsControl {
    private static Logger log = LoggerFactory.getLogger(PortalsControl.class);
    @Autowired
    AppPlatformService appPlatformService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    WebPortalService webPortalService;
    @Autowired
    UserManageService userManageService;

    @RequestMapping(value={"/portals/first.do"})
    public String first(ModelMap map) {
        return "protals/index/default/first";
    }

    @RequestMapping(value={"/portals/index.do"})
    public String index(ModelMap map, HttpServletRequest request) {
        try {
            String isSuccessLogin = request.getParameter("isSuccessLogin");
            HttpSession session = request.getSession();
            session.setAttribute("isSuccessLogin", (Object)isSuccessLogin);
            String isLogOut = request.getParameter("isLogOut");
            if ("1".equals(isLogOut)) {
                session.removeAttribute("isSuccessLogin");
            }
            String appLogoUrl = this.systemConfigService.getValueByCode("MDP_SERVER_URL") + "/";
            String casUrl = this.systemConfigService.getValueByCode("portals_cas_url") + "/";
            List<Object> xyy = new ArrayList();
            try {
                xyy = this.appPlatformService.getAppRanking("3", "1");
            }
            catch (Exception e2) {
                log.error("\u83b7\u53d6\u9996\u9875\u4fe1\u606f\u5f02\u5e38:\u67e5\u8be2\u65b0\u5e94\u7528\u5217\u8868\u5931\u8d25", (Throwable)e2);
            }
            List<Object> rmyy = new ArrayList();
            try {
                rmyy = this.appPlatformService.getAppRanking("4", "2");
            }
            catch (Exception e3) {
                log.error("\u83b7\u53d6\u9996\u9875\u4fe1\u606f\u5f02\u5e38:\u67e5\u8be2\u70ed\u95e8\u5e94\u7528\u5217\u8868\u5931\u8d25", (Throwable)e3);
            }
            QueryWebPortalBean queryWebPortalBean = new QueryWebPortalBean();
            Page page = new Page();
            page.setRp(5);
            page.setPage(1);
            queryWebPortalBean.setContentType("01");
            List<WebPortal> listNew = this.getPortTalList(queryWebPortalBean, page);
            queryWebPortalBean.setContentType("02");
            List<WebPortal> gflistNew = this.getPortTalList(queryWebPortalBean, page);
            queryWebPortalBean.setContentType("03");
            List<WebPortal> tzlistNew = this.getPortTalList(queryWebPortalBean, page);
            queryWebPortalBean.setContentType("01");
            queryWebPortalBean.setImgPath("check");
            List<WebPortal> imglistNew = this.getPortTalList(queryWebPortalBean, page);
            map.put((Object)"imgList", imglistNew);
            map.put((Object)"xwList", listNew);
            map.put((Object)"gfList", gflistNew);
            map.put((Object)"tzList", tzlistNew);
            map.put((Object)"xyy", xyy);
            map.put((Object)"rmyy", rmyy);
            map.put((Object)"mamURL", (Object)appLogoUrl);
            map.put((Object)"casURL", (Object)casUrl);
        }
        catch (Exception e4) {
            log.error("\u83b7\u53d6\u9996\u9875\u4fe1\u606f\u5f02\u5e38", (Throwable)e4);
        }
        return "protals/index/default/index";
    }

    @RequestMapping(value={"/portals/downloadCenter.do"})
    public String downloadCenter(ModelMap map, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            String isLogOut = request.getParameter("isLogOut");
            if ("1".equals(isLogOut)) {
                session.removeAttribute("isSuccessLogin");
            }
            String casUrl = this.systemConfigService.getValueByCode("portals_cas_url") + "/";
            map.put((Object)"casURL", (Object)casUrl);
        }
        catch (Exception e2) {
            log.error("\u8df3\u8f6c\u4e0b\u8f7d\u4e2d\u5fc3\u9875\u9762\u5f02\u5e38", (Throwable)e2);
        }
        return "protals/index/default/download";
    }

    @RequestMapping(value={"/portals/report.do"})
    public String report(HttpServletResponse response, ModelMap map, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            String isLogOut = request.getParameter("isLogOut");
            if ("1".equals(isLogOut)) {
                session.removeAttribute("isSuccessLogin");
            }
            String casUrl = this.systemConfigService.getValueByCode("portals_cas_url") + "/";
            map.put((Object)"casURL", (Object)casUrl);
        }
        catch (Exception e2) {
            log.error("\u8df3\u8f6c\u7edf\u8ba1\u9875\u9762\u5f02\u5e38", (Throwable)e2);
        }
        return "protals/index/default/report";
    }

    @RequestMapping(value={"/portals/getAppDetail.do"})
    public void getAppDetail(HttpServletResponse response, String appId) {
        AppDetailQueryOutResultContent appDetail = this.appPlatformService.applicationDetail(appId);
        Util.writeUtf8Text(response, Util.toJsonStr(appDetail));
    }

    @RequestMapping(value={"/portals/getReportData.do"})
    public void getReportData(HttpServletResponse response, String deptId) {
        AppUsageQueryOutResult usage = this.appPlatformService.getAppUsageStatistics(deptId, "1");
        Util.writeUtf8Text(response, Util.toJsonStr(usage));
    }

    @RequestMapping(value={"/portals/getPortTalDetail.do"})
    public void getPortTalDetail(HttpServletResponse response, String portTalId) {
        WebPortal webPortal = this.webPortalService.getWebPortal((Serializable)((Object)portTalId));
        Person person = this.userManageService.queryPersonById(webPortal.getPersonId());
        webPortal.setPersonId(person.getName());
        webPortal.setContentState(Util.getDate("yyyy-MM-dd HH:mm:ss", webPortal.getCreateDate()));
        Util.writeUtf8Text(response, Util.toJsonStr(webPortal));
    }

    @RequestMapping(value={"/portals/getPortTalList.do"})
    public List<WebPortal> getPortTalList(QueryWebPortalBean queryWebPortalBean, Page page) {
        queryWebPortalBean.setContentState("1");
        Person person = null;
        queryWebPortalBean.setContentType(queryWebPortalBean.getContentType());
        List<WebPortal> list = this.webPortalService.query(queryWebPortalBean, page);
        ArrayList<WebPortal> listNew = new ArrayList<WebPortal>();
        if (null != list && list.size() > 0) {
            for (WebPortal webPortal : list) {
                QueryWebPortalBean queryWebPortalBeanNew = new QueryWebPortalBean();
                BeanUtils.copyProperties((Object)webPortal, (Object)queryWebPortalBeanNew);
                queryWebPortalBeanNew.setContentTypeName(this.commonCodePbService.getCodeNameByCode(webPortal.getContentType(), "contentType"));
                queryWebPortalBeanNew.setContentStateName(this.commonCodePbService.getCodeNameByCode(webPortal.getContentState(), "contentState"));
                person = this.userManageService.queryPersonById(webPortal.getPersonId());
                queryWebPortalBeanNew.setPersonId(person.getName());
                listNew.add(queryWebPortalBeanNew);
            }
        }
        return listNew;
    }

    @RequestMapping(value={"/portals/getPortTalListJson.do"})
    public void getPortTalListJson(HttpServletResponse response, QueryWebPortalBean queryWebPortalBean, Page page) {
        queryWebPortalBean.setContentState("1");
        Person person = null;
        queryWebPortalBean.setContentType(queryWebPortalBean.getContentType());
        List<WebPortal> list = this.webPortalService.query(queryWebPortalBean, page);
        PageBean pageBean = new PageBean();
        BeanUtils.copyProperties((Object)page, (Object)pageBean);
        ArrayList<QueryWebPortalBean> listNew = new ArrayList<QueryWebPortalBean>();
        if (null != list && list.size() > 0) {
            for (WebPortal webPortal : list) {
                QueryWebPortalBean queryWebPortalBeanNew = new QueryWebPortalBean();
                BeanUtils.copyProperties((Object)webPortal, (Object)queryWebPortalBeanNew);
                queryWebPortalBeanNew.setContentTypeName(this.commonCodePbService.getCodeNameByCode(webPortal.getContentType(), "contentType"));
                queryWebPortalBeanNew.setContentStateName(this.commonCodePbService.getCodeNameByCode(webPortal.getContentState(), "contentState"));
                person = this.userManageService.queryPersonById(webPortal.getPersonId());
                queryWebPortalBeanNew.setPersonId(person.getName());
                if (webPortal.getContentType().equals("05")) {
                    queryWebPortalBeanNew.setLogo("word");
                } else if (webPortal.getContentType().equals("06")) {
                    queryWebPortalBeanNew.setLogo("api");
                } else if (webPortal.getContentType().equals("07")) {
                    queryWebPortalBeanNew.setLogo("tool");
                }
                queryWebPortalBeanNew.setContentState(Util.getDate("yyyy-MM-dd HH:mm:ss", webPortal.getCreateDate()));
                listNew.add(queryWebPortalBeanNew);
            }
        }
        pageBean.setData(listNew);
        pageBean.setState("1");
        Util.writeUtf8Text(response, Util.toJsonStr(pageBean));
    }

    @RequestMapping(value={"/portals/getMoreWeb.do"})
    public String getMoreWeb(ModelMap map, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            String isLogOut = request.getParameter("isLogOut");
            if ("1".equals(isLogOut)) {
                session.removeAttribute("isSuccessLogin");
            }
            String casUrl = this.systemConfigService.getValueByCode("portals_cas_url") + "/";
            map.put((Object)"casURL", (Object)casUrl);
        }
        catch (Exception e2) {
            log.error("\u8df3\u8f6c\u9996\u9875\u4fe1\u606f\u4e2d\u5fc3\u9875\u9762\u5f02\u5e38", (Throwable)e2);
        }
        return "protals/index/default/more";
    }

    @RequestMapping(value={"/portals/exportExcel.do"})
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, ModelMap map, String deptId) {
        log.info("exportExcel...............");
        try {
            String fileTitle = "\u5e94\u7528\u7edf\u8ba1\u62a5\u8868";
            String fileName = Util.toUtf8String("expReport") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            AppUsageQueryOutResult usage = this.appPlatformService.getAppUsageStatistics(deptId, "1");
            ExcelUtil.getExcelForReport((OutputStream)response.getOutputStream(), "\u7edf\u8ba1\u62a5\u8868", fileTitle, usage);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            Util.writeUtf8Text(response, MessageManager.getProMessage(this.message, "exp.error.msg") + ":" + e2.getMessage());
        }
    }
}

