/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.report.service.OnlineTimeReportService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class OnlineTimeReportController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private OnlineTimeReportService service;
    private static final Logger log = LoggerFactory.getLogger(OnlineTimeReportController.class);

    @RequestMapping(value={"/report/OnlineTimeReportController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            date = cal.getTime();
            String ToDate = Util.getDate("yyyy-MM-dd", date);
            cal.setTime(date);
            cal.add(5, -1);
            date = cal.getTime();
            String fromDate = Util.getDate("yyyy-MM-dd", date);
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)ToDate);
        }
        catch (Exception e2) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e2);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/report/OnlineTimeReportController/queryData.do"})
    public void queryData(HttpServletRequest request, HttpServletResponse response, String depId, String codeOrName, String startDate, String endDate, String cardType, int page, int rows, String sort, String order, String expFlag) {
        Page pageE = new Page(page, rows);
        List<Map<String, Object>> queryData = this.service.queryOnOffTimeData(depId, codeOrName, startDate, endDate, cardType, sort, order, pageE);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", pageE.getTotal());
        result.put("rows", queryData);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/report/OnlineTimeReportController/expData.do"})
    public void expData(HttpServletRequest request, HttpServletResponse response, String depId, String codeOrName, String startDate, String endDate, String cardType, String sort, String order, String expFlag) {
        List<Map<String, Object>> queryData = this.service.queryOnOffTimeData(depId, codeOrName, startDate, endDate, cardType, sort, order, null);
        if (queryData == null) {
            queryData = new ArrayList<Map<String, Object>>();
        }
        if (queryData.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CODE", MessageManager.getProMessage(this.message, "bims.person.page.info.code"));
        map.put("NAME", MessageManager.getProMessage(this.message, "bims.person.page.info.name"));
        map.put("DEPNAME", MessageManager.getProMessage(this.message, "bims.person.page.info.dep"));
        map.put("CARDTYPENAME", "\u5361\u7c7b\u578b");
        map.put("ONLINETIME", "\u5728\u7ebf\u65f6\u957f");
        log.info("#\u5e26\u7ffb\u8bd1\u5b57\u6bb5>" + map);
        Map<String, Object> keys = queryData.get(0);
        Iterator<String> it = keys.keySet().iterator();
        Object name = null;
        ArrayList<String> heanderNames = new ArrayList<String>();
        heanderNames.add(MessageManager.getProMessage(this.message, "bims.person.page.info.code"));
        heanderNames.add(MessageManager.getProMessage(this.message, "bims.person.page.info.name"));
        heanderNames.add(MessageManager.getProMessage(this.message, "bims.person.page.info.dep"));
        heanderNames.add("\u5361\u7c7b\u578b");
        heanderNames.add("\u5728\u7ebf\u65f6\u957f");
        ArrayList<String> rowkeys = new ArrayList<String>();
        rowkeys.add("CODE");
        rowkeys.add("NAME");
        rowkeys.add("DEPNAME");
        rowkeys.add("CARDTYPENAME");
        rowkeys.add("ONLINETIME");
        String fileName = Util.toUtf8String("\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1") + ".xls";
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            ExcelUtil.exportExcel("\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1", (OutputStream)response.getOutputStream(), "001", queryData, heanderNames.toArray(new String[0]), rowkeys.toArray(new String[0]));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    @RequestMapping(value={"/report/OnlineTimeReportController/toDetail.do"})
    public String toDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "report/onlineReport/default/detail";
    }

    @RequestMapping(value={"/report/OnlineTimeReportController/queryDetailData.do"})
    public void queryDetailData(HttpServletRequest request, HttpServletResponse response, String personId, String codeOrName, String startDate, String endDate, String cardType, int page, int rows, String sort, String order) {
        Page pageE = new Page(page, rows);
        List<Map<String, Object>> queryData = this.service.queryOnOffTimeDetailData(personId, startDate, endDate, cardType, pageE);
        Util.writeUtf8Text(response, Util.toJsonStr(queryData));
    }

    @RequestMapping(value={"/report/OnlineTimeReportController/expDetailData.do"})
    public void exoDetailData(HttpServletRequest request, HttpServletResponse response, String personId, String codeOrName, String startDate, String endDate, String cardType, String sort, String order) {
        List<Map<String, Object>> queryData = this.service.queryOnOffTimeDetailData(personId, startDate, endDate, cardType, null);
        ArrayList<String> heanderNames = new ArrayList<String>();
        heanderNames.add("\u4e0a\u7ebf\u65f6\u95f4");
        heanderNames.add("\u4e0b\u7ebf\u65f6\u95f4");
        heanderNames.add("\u5728\u7ebf\u65f6\u957f");
        ArrayList<String> rowkeys = new ArrayList<String>();
        rowkeys.add("ONTIME");
        rowkeys.add("OFFTIME");
        rowkeys.add("ONLINETIME");
        int size = 50000;
        try {
            if (queryData.size() > size) {
                String agent = request.getHeader("User-Agent");
                String dFileName = "\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1.zip";
                dFileName = agent != null && agent.indexOf("MSIE") != -1 ? URLEncoder.encode(dFileName, "UTF-8") : (agent != null && (agent.toLowerCase().indexOf("chrome") != -1 || agent.toLowerCase().indexOf("firefox") != -1) ? new String(dFileName.getBytes("UTF-8"), "ISO-8859-1") : "sfzzp.zip");
                Object input = null;
                ZipOutputStream zipOut = null;
                response.setContentType("application/x-msdownload");
                response.setHeader("Content-Disposition", "attachment;filename=" + dFileName);
                ServletOutputStream os = response.getOutputStream();
                zipOut = new ZipOutputStream((OutputStream)os);
                zipOut.setEncoding("UTF-8");
                int inexStart = 0;
                int fileIndex = 1;
                while (inexStart < queryData.size()) {
                    int indexEnd = inexStart + size;
                    if (indexEnd > queryData.size()) {
                        indexEnd = queryData.size();
                    }
                    List<Map<String, Object>> subList = queryData.subList(inexStart, inexStart + size);
                    inexStart = indexEnd;
                    String fileName = "\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1" + fileIndex + ".xls";
                    zipOut.putNextEntry(new ZipEntry(fileName));
                    ExcelUtil.exportExcel("\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1", (OutputStream)zipOut, "001", subList, heanderNames.toArray(new String[0]), rowkeys.toArray(new String[0]));
                    ++fileIndex;
                }
                zipOut.close();
                os.flush();
                os.close();
            } else {
                String fileName = Util.toUtf8String("\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1") + ".xls";
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                ExcelUtil.exportExcel("\u5728\u7ebf\u65f6\u957f\u7edf\u8ba1", (OutputStream)response.getOutputStream(), "001", queryData, heanderNames.toArray(new String[0]), rowkeys.toArray(new String[0]));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }
}

