/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.rptms.bean.ChartParam;
import com.xdja.pams.rptms.entity.ReportChart;
import com.xdja.pams.rptms.service.ReportChartService;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.TextAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReportChartServiceImpl
implements ReportChartService {
    private static final Logger log = LoggerFactory.getLogger(ReportChartServiceImpl.class);

    @Override
    public String createReportChart(ReportChart reportChart, List<Map<String, Object>> data, HttpServletResponse response) {
        this.createReportChart(reportChart, data, response, null);
        return null;
    }

    @Override
    public String createReportChart(ReportChart reportChart, List<Map<String, Object>> data, HttpServletResponse response, ChartParam param) {
        try {
            String[] categoryNameArr;
            String[] valueColumnNameArr;
            String valueColumnNames = reportChart.getValueColumnName();
            String valueNames = reportChart.getValueName();
            String categoryColumnNames = reportChart.getCategoryColumnName();
            String categoryNames = reportChart.getCategoryName();
            if (StringUtils.isBlank((CharSequence)valueColumnNames) || StringUtils.isBlank((CharSequence)valueNames)) {
                throw new RuntimeException("\u7edf\u8ba1\u56fe\u8868\u7c7b\u5217\u6216\u503c\u5217\u672a\u8bbe\u7f6e");
            }
            String[] valueNameArr = valueNames.split(",");
            if (valueNameArr.length != (valueColumnNameArr = valueColumnNames.split(",")).length) {
                throw new RuntimeException("\u7edf\u8ba1\u56fe\u8868\u5217\u503c\u672a\u5bf9\u5e94");
            }
            if ("2".equals(reportChart.getChartType())) {
                return this.createPieChart(reportChart, data, response, param);
            }
            if (StringUtils.isBlank((CharSequence)categoryColumnNames) || StringUtils.isBlank((CharSequence)categoryNames)) {
                throw new RuntimeException("\u7edf\u8ba1\u56fe\u8868\u7c7b\u5217\u6216\u503c\u5217\u672a\u8bbe\u7f6e");
            }
            String[] categoryColumnNameArr = categoryColumnNames.split(",");
            if (categoryColumnNameArr.length != (categoryNameArr = categoryNames.split(",")).length) {
                throw new RuntimeException("\u7edf\u8ba1\u56fe\u8868\u5217\u503c\u672a\u5bf9\u5e94");
            }
            if ("1".equals(reportChart.getChartType())) {
                return this.createBarChart(reportChart, data, response, param);
            }
            if ("3".equals(reportChart.getChartType())) {
                return this.createStackedBarChart(reportChart, data, response, param);
            }
        }
        catch (NumberFormatException e2) {
            throw new RuntimeException("\u53c2\u6570\u975e\u6cd5\u5f02\u5e38");
        }
        return "";
    }

    public String createPieChart(ReportChart reportChart, List<Map<String, Object>> data, HttpServletResponse response, ChartParam param) {
        DefaultPieDataset dataset = this.getDefaultPieDataset(data, reportChart.getCategoryColumnName(), reportChart.getValueColumnName());
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelFont(new Font("\u5b8b\u4f53", 1, 14));
        if (param != null && param.getPieLabelPaint() != null) {
            plot.setLabelPaint((Paint)ChartColor.decode((String)param.getPieLabelPaint()));
        }
        if (param != null && param.getPieLabelLinkPaint() != null) {
            plot.setLabelLinkPaint((Paint)ChartColor.decode((String)param.getPieLabelLinkPaint()));
        }
        plot.setBackgroundAlpha(0.9f);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0},{2}", (NumberFormat)new DecimalFormat("0.0"), (NumberFormat)new DecimalFormat("0.0%")));
        if (param != null && param.getPieLabelBackgroundPaint() != null) {
            plot.setLabelBackgroundPaint((Paint)ChartColor.decode((String)param.getPieLabelBackgroundPaint()));
        }
        plot.setLabelOutlinePaint(null);
        if (param != null && param.getPlotBackgroundPaint() != null) {
            plot.setBackgroundPaint((Paint)ChartColor.decode((String)param.getPlotBackgroundPaint()));
        }
        plot.setLabelShadowPaint(null);
        plot.setOutlinePaint(null);
        if (StringUtils.isNotBlank((CharSequence)reportChart.getSubReportURL())) {
            plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator(reportChart.getSubReportURL()));
        }
        return this.createChart(chart, reportChart, response, param);
    }

    public String createBarChart(ReportChart reportChart, List<Map<String, Object>> data, HttpServletResponse response, ChartParam param) {
        String valueNames = reportChart.getValueName();
        String[] valueNameArr = valueNames.split(",");
        String yName = valueNameArr[0];
        if (yName.indexOf("@") > 0) {
            String[] temp = yName.split("@");
            yName = temp[0];
            valueNameArr[0] = temp[1];
        }
        List<CategoryDataset> datasets = this.getStackedBarDataset(data, reportChart.getCategoryColumnName(), reportChart.getValueColumnName(), reportChart.getValueName());
        String percentValueColumnNames = reportChart.getPercentageValueName();
        String percentValueNames = reportChart.getPercentageValueName();
        String[] percentValueNameArr = null;
        List<CategoryDataset> percentDatasets = null;
        if (StringUtils.isNotBlank((CharSequence)percentValueNames) && StringUtils.isNotBlank((CharSequence)percentValueColumnNames)) {
            percentValueNameArr = percentValueNames.split(",");
            percentDatasets = this.getCategoryDataset(data, reportChart.getCategoryColumnName(), reportChart.getPercentageValueColumnName(), reportChart.getPercentageValueName());
        }
        String categoryName = reportChart.getCategoryName();
        JFreeChart chart = ChartFactory.createBarChart((String)"", (String)categoryName, (String)yName, (CategoryDataset)datasets.get(0), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.setXYFont(chart, param);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setOutlinePaint(null);
        if (param != null && param.getPlotBackgroundPaint() != null) {
            plot.setBackgroundPaint((Paint)ChartColor.decode((String)param.getPlotBackgroundPaint()));
        }
        BarRenderer renderer = new BarRenderer();
        renderer.setMaximumBarWidth(0.05);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        if (percentDatasets != null && percentDatasets.size() > 0) {
            NumberAxis numberaxis3 = new NumberAxis(percentValueNameArr[0]);
            numberaxis3.setNumberFormatOverride(NumberFormat.getPercentInstance());
            numberaxis3.setAutoRange(false);
            numberaxis3.setLowerMargin(0.02);
            numberaxis3.setUpperMargin(0.02);
            plot.setRangeAxis(1, (ValueAxis)numberaxis3);
            plot.setDataset(1, percentDatasets.get(0));
            plot.mapDatasetToRangeAxis(1, 1);
            LineAndShapeRenderer lineandshaperenderer = this.createLineAndShapeRenderer();
            plot.setRenderer(1, (CategoryItemRenderer)lineandshaperenderer);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        }
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setItemMargin(0.0);
        renderer.setItemLabelsVisible(true);
        if (param != null && param.getBarSeriesPaint() != null) {
            renderer.setSeriesPaint(0, (Paint)ChartColor.decode((String)param.getBarSeriesPaint()));
        }
        renderer.setShadowVisible(false);
        renderer.setBaseItemLabelsVisible(true);
        ItemLabelPosition itemLabelPositionFallback = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT, TextAnchor.HALF_ASCENT_LEFT, -0.0);
        renderer.setPositiveItemLabelPositionFallback(itemLabelPositionFallback);
        renderer.setNegativeItemLabelPositionFallback(itemLabelPositionFallback);
        if (StringUtils.isNotBlank((CharSequence)reportChart.getSubReportURL())) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator(reportChart.getSubReportURL()));
        }
        plot.setRenderer((CategoryItemRenderer)renderer);
        if (param == null || param.getHeight() == 0 || param.getWidth() == 0) {
            param = new ChartParam();
            param.setHeight(270);
            int width = data.size() * 35;
            if (width < 700) {
                width = 700;
            }
            param.setWidth(width);
        }
        return this.createChart(chart, reportChart, response, param);
    }

    private String createStackedBarChart(ReportChart reportChart, List<Map<String, Object>> data, HttpServletResponse response, ChartParam param) {
        String valueNames = reportChart.getValueName();
        String[] valueNameArr = valueNames.split(",");
        List<CategoryDataset> datasets = this.getStackedBarDataset(data, reportChart.getCategoryColumnName(), reportChart.getValueColumnName(), reportChart.getValueName());
        String percentValueColumnNames = reportChart.getPercentageValueColumnName();
        String percentValueNames = reportChart.getPercentageValueName();
        String[] percentValueNameArr = null;
        List<CategoryDataset> percentDatasets = null;
        if (!StringUtils.isNotBlank((CharSequence)percentValueNames) || !StringUtils.isNotBlank((CharSequence)percentValueColumnNames)) {
            throw new RuntimeException("\u7edf\u8ba1\u56fe\u8868\u7edf\u8ba1\u7387\u5217\u503c\u672a\u5bf9\u5e94");
        }
        percentValueNameArr = percentValueNames.split(",");
        percentDatasets = this.getCategoryDataset(data, reportChart.getCategoryColumnName(), reportChart.getPercentageValueColumnName(), reportChart.getPercentageValueName());
        String categoryName = reportChart.getCategoryName();
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"", (String)categoryName, (String)valueNameArr[0], (CategoryDataset)datasets.get(0), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.setXYFont(chart, param);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setOutlinePaint(null);
        if (param != null && param.getPlotBackgroundPaint() != null) {
            plot.setBackgroundPaint((Paint)ChartColor.decode((String)param.getPlotBackgroundPaint()));
        }
        StackedBarRenderer barRenderer = new StackedBarRenderer();
        barRenderer.setMaximumBarWidth(0.05);
        barRenderer.setBaseItemLabelsVisible(true);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        plot.setRenderer((CategoryItemRenderer)barRenderer);
        if (percentDatasets != null && percentDatasets.size() > 0) {
            NumberAxis numberaxis3 = new NumberAxis(percentValueNameArr[0]);
            numberaxis3.setNumberFormatOverride(NumberFormat.getPercentInstance());
            numberaxis3.setAutoRange(false);
            numberaxis3.setLowerMargin(0.02);
            numberaxis3.setUpperMargin(0.02);
            plot.setRangeAxis(2, (ValueAxis)numberaxis3);
            plot.setDataset(2, percentDatasets.get(0));
            plot.mapDatasetToRangeAxis(2, 2);
            LineAndShapeRenderer lineandshaperenderer = this.createLineAndShapeRenderer();
            plot.setRenderer(2, (CategoryItemRenderer)lineandshaperenderer);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        }
        if (param == null || param.getHeight() == 0 || param.getWidth() == 0) {
            param = new ChartParam();
            param.setHeight(270);
            int width = data.size() * 35;
            param.setWidth(width);
        }
        return this.createChart(chart, reportChart, response, param);
    }

    private String createChart(JFreeChart chart, ReportChart reportChart, HttpServletResponse response, ChartParam param) {
        chart.setTitle(new TextTitle(reportChart.getTitle() == null ? "" : reportChart.getTitle(), new Font("\u5b8b\u4f53", 2, 22)));
        LegendTitle legend = chart.getLegend(0);
        legend.setItemFont(new Font("\u5b8b\u4f53", 1, 14));
        legend.setBorder(0.0, 0.0, 0.0, 0.0);
        if (param != null && param.getLegendItemPaint() != null) {
            legend.setItemPaint((Paint)ChartColor.decode((String)param.getLegendItemPaint()));
        }
        if (param != null && param.getLegendBackgroundPaint() != null) {
            legend.setBackgroundPaint((Paint)ChartColor.decode((String)param.getLegendBackgroundPaint()));
        }
        if (param != null && param.getBackgroundPaint() != null) {
            chart.setBackgroundPaint((Paint)ChartColor.decode((String)param.getBackgroundPaint()));
        }
        StandardEntityCollection entityCollection = new StandardEntityCollection();
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)entityCollection);
        String filename = null;
        try {
            int width = 700;
            int height = 270;
            if (param != null && param.getWidth() != 0 && param.getHeight() != 0) {
                width = param.getWidth();
                height = param.getHeight();
            }
            PrintWriter pw = response.getWriter();
            filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info, null);
            String map = "map0";
            if (param != null && StringUtils.isNotBlank((CharSequence)param.getMap()) && !"null".equalsIgnoreCase(param.getMap())) {
                map = param.getMap();
            } else {
                if (param == null) {
                    param = new ChartParam();
                }
                param.setMap(map);
            }
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)map, (ChartRenderingInfo)info, (boolean)false);
        }
        catch (IOException e2) {
            log.error("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25", (Throwable)e2);
            throw new RuntimeException("");
        }
        return filename;
    }

    private List<CategoryDataset> getCategoryDataset(List<Map<String, Object>> data, String categoryColumn, String valueColumns, String valueNames) {
        ArrayList<CategoryDataset> list = new ArrayList<CategoryDataset>();
        int i = 0;
        for (String valueColumn : valueColumns.split(",")) {
            String[] valueNameArr = valueNames.split(",");
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            String valueName = valueNameArr[i++];
            for (Map<String, Object> row : data) {
                Object category = row.get(categoryColumn);
                category = category.toString().replaceAll("<([^>]*?)>", "");
                Object value = row.get(valueColumn);
                dataset.addValue((Number)value, (Comparable)((Object)valueName), (Comparable)((Object)category.toString()));
            }
            list.add((CategoryDataset)dataset);
        }
        return list;
    }

    public List<CategoryDataset> getStackedBarDataset(List<Map<String, Object>> data, String categoryColumn, String valueColumns, String valueNames) {
        ArrayList<CategoryDataset> list = new ArrayList<CategoryDataset>();
        int i = 0;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        DefaultCategoryDataset countDataset = new DefaultCategoryDataset();
        HashMap<String, Number> categoryCount = new HashMap<String, Number>();
        for (String valueColumn : valueColumns.split(",")) {
            String[] valueNameArr = valueNames.split(",");
            String valueName = valueNameArr[i++];
            if (valueName.indexOf("@") > 0) {
                String[] temp = valueName.split("@");
                valueName = temp[1];
            }
            for (Map<String, Object> row : data) {
                Object category = row.get(categoryColumn);
                category = category.toString().replaceAll("<([^>]*?)>", "");
                Object value = row.get(valueColumn);
                dataset.addValue((Number)value, (Comparable)((Object)valueName), (Comparable)((Object)category.toString()));
                if (categoryCount.get(category.toString()) == null) {
                    categoryCount.put(category.toString(), (Number)value);
                    continue;
                }
                Double tmp = ((Number)categoryCount.get(category.toString())).doubleValue() + ((Number)value).doubleValue();
                categoryCount.put(category.toString(), tmp);
            }
        }
        for (String cg : categoryCount.keySet()) {
            countDataset.addValue((Number)categoryCount.get(cg), (Comparable)((Object)"\u5408\u8ba1"), (Comparable)((Object)cg));
        }
        list.add((CategoryDataset)dataset);
        list.add((CategoryDataset)countDataset);
        return list;
    }

    private DefaultPieDataset getDefaultPieDataset(List<Map<String, Object>> data, String valueNames, String valueColumns) {
        Number v;
        String[] allArr;
        if (StringUtils.isBlank((CharSequence)valueNames) || StringUtils.isBlank((CharSequence)valueColumns)) {
            throw new RuntimeException("\u7edf\u8ba1\u56fe\u8868\u7c7b\u522b\u5217\u6216\u503c\u5217\u672a\u8bbe\u7f6e");
        }
        DefaultPieDataset dataset = new DefaultPieDataset();
        HashMap<String, Number> allMap = new HashMap<String, Number>();
        HashMap dMap = new HashMap();
        HashMap<String, Number> xMap = new HashMap<String, Number>();
        Number zs = null;
        for (Map<String, Object> row : data) {
            Number value = (Number)row.get(valueColumns);
            allMap.put(String.valueOf(row.get(valueNames)), value);
            if (zs == null) {
                zs = value;
                continue;
            }
            zs = value.doubleValue() + zs.doubleValue();
        }
        Set allSet = allMap.keySet();
        for (String name : allArr = allSet.toArray(new String[0])) {
            v = (Number)allMap.get(name);
            if (!(v.doubleValue() / zs.doubleValue() < 0.01)) continue;
            xMap.put(name, v);
            allMap.remove(name);
        }
        if (xMap.size() == 1) {
            allMap.putAll(xMap);
        } else if (xMap.size() > 1) {
            Number xZh = null;
            Set xSet = xMap.keySet();
            for (String name : xSet) {
                v = (Number)xMap.get(name);
                if (xZh == null) {
                    xZh = v;
                    continue;
                }
                xZh = xZh.doubleValue() + v.doubleValue();
            }
            allMap.put("\u5176\u5b83", xZh);
        }
        allSet = allMap.keySet();
        for (String name : allSet) {
            dataset.setValue((Comparable)((Object)name), (Number)allMap.get(name));
        }
        return dataset;
    }

    private void setXYFont(JFreeChart chart, ChartParam param) {
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setTickLabelFont(new Font("sans-serif", 0, 14));
        domainAxis.setLabelFont(new Font("\u5b8b\u4f53", 0, 14));
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setTickLabelFont(new Font("\u5b8b\u4f53", 0, 14));
        domainAxis.setCategoryMargin(0.5);
        ValueAxis rAxis = plot.getRangeAxis();
        rAxis.setLowerMargin(0.2);
        rAxis.setUpperMargin(0.2);
        rAxis.setLowerBound(0.0);
        rAxis.setTickLabelFont(new Font("sans-serif", 0, 14));
        rAxis.setLabelFont(new Font("\u5b8b\u4f53", 0, 14));
        chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        if (param != null && param.getAxisLinePaint() != null) {
            domainAxis.setAxisLinePaint((Paint)ChartColor.decode((String)param.getAxisLinePaint()));
            domainAxis.setLabelPaint((Paint)ChartColor.decode((String)param.getAxisLinePaint()));
            domainAxis.setTickLabelPaint((Paint)ChartColor.decode((String)param.getAxisLinePaint()));
            rAxis.setAxisLinePaint((Paint)ChartColor.decode((String)param.getAxisLinePaint()));
            rAxis.setLabelPaint((Paint)ChartColor.decode((String)param.getAxisLinePaint()));
            rAxis.setTickLabelPaint((Paint)ChartColor.decode((String)param.getAxisLinePaint()));
        }
    }

    private LineAndShapeRenderer createLineAndShapeRenderer() {
        LineAndShapeRenderer lineandshaperenderer = new LineAndShapeRenderer();
        lineandshaperenderer.setSeriesPaint(0, (Paint)new Color(255, 0, 255));
        lineandshaperenderer.setSeriesPaint(1, (Paint)new Color(0, 0, 255));
        lineandshaperenderer.setSeriesPaint(2, (Paint)Color.BLACK);
        lineandshaperenderer.setShapesVisible(true);
        return lineandshaperenderer;
    }
}

