/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.ReportTemplateManageService;
import com.xdja.pams.rptms.service.ViewReportService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.ModelMap;

@Service
public abstract class ReportResultAbs {
    @Autowired
    private ReportTemplateManageService reportTemplateManageService;
    @Autowired
    protected ReportManagerService reportManagerService;
    @Autowired
    protected ViewReportService viewReportService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(ReportResultAbs.class);

    @Transactional
    public void output(ModelMap modelMap, Map<String, Object> paramMap, String reportId, PageParam pageParam, HttpServletResponse response) {
        ReportBean reportBean = this.reportManagerService.getReportById(reportId);
        this.output(modelMap, paramMap, reportBean, pageParam, response);
    }

    @Transactional
    public void output(ModelMap modelMap, Map<String, Object> paramMap, ReportBean reportBean, PageParam pageParam, HttpServletResponse response) {
        try {
            List<Map<String, Object>> dataList = this.viewReportService.getReportData(reportBean, paramMap, null);
            response.setContentType(this.getContentType());
            response.setHeader("Content-Disposition", "attachment;filename = " + reportBean.getReportFileId() + "." + this.getSubffix());
            this.output(paramMap, reportBean, dataList, (OutputStream)response.getOutputStream());
        }
        catch (IOException e2) {
            log.error("\u5bfc\u51fa\u62a5\u8868\u5931\u8d25", (Throwable)e2);
            throw new RuntimeException("\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:" + e2.getMessage());
        }
    }

    @Transactional
    public void output(Map<String, Object> paramMap, ReportBean reportBean, List<?> dataList, String outputFilePath) {
        try {
            File file = new File(outputFilePath);
            FileOutputStream outputStream = new FileOutputStream(file);
            this.output(paramMap, reportBean, dataList, outputStream);
        }
        catch (FileNotFoundException e2) {
            log.error("\u521b\u5efa\u6587\u4ef6\u8f93\u51fa\u6d41\u9519\u8bef", (Throwable)e2);
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u8f93\u51fa\u6d41\u9519\u8bef\uff1a" + e2.getMessage());
        }
    }

    @Transactional
    public void output(Map<String, Object> paramMap, String reportId, OutputStream outputStream) {
        ReportBean reportBean = this.reportManagerService.getReportById(reportId);
        List<Map<String, Object>> returnObject = this.viewReportService.getReportData(reportBean, paramMap, null);
        this.output(paramMap, reportBean, returnObject, outputStream);
    }

    public abstract JRExporter getJRExporter();

    public abstract String getSubffix();

    public abstract String getContentType();

    @Transactional
    public String getReportFilePath(ReportBean reportBean) {
        File file;
        String templateFilePath = null;
        if (reportBean.getReportFileId() != null && !(file = new File(templateFilePath = this.reportTemplateManageService.queryReportTemplateById(reportBean.getReportFileId()).getFileAllPath())).exists()) {
            log.error("$\u62a5\u8868\u6587\u4ef6\u4e0d\u5b58\u5728:" + templateFilePath);
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.templateManage.error.filenotexist"));
        }
        return templateFilePath;
    }

    @Transactional
    public void output(Map<String, Object> paramMap, ReportBean reportBean, List<?> dataList, OutputStream outputStream) {
        try {
            String jrxmlPath = this.getReportFilePath(reportBean);
            JasperReport jasperReport = JasperCompileManager.compileReport((String)jrxmlPath);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, paramMap, (JRDataSource)new JRBeanCollectionDataSource(dataList));
            JRExporter exporter = this.getJRExporter();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.exportReport();
        }
        catch (JRException e2) {
            log.error("\u5bfc\u51fa\u62a5\u8868\u5931\u8d25", (Throwable)e2);
            throw new RuntimeException("\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:" + e2.getMessage());
        }
    }
}

